/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public final class DebugLog {
    private final Path logFilePath;
    private final long rotateBytes;
    private final ReentrantLock lock = new ReentrantLock();

    public DebugLog(Path logFilePath, long rotateBytes) {
        this.logFilePath = Objects.requireNonNull(logFilePath, "logFilePath");
        this.rotateBytes = Math.max(262144L, rotateBytes);
    }

    public void info(String msg) {
        this.write("INFO", msg, null);
    }

    public void warn(String msg) {
        this.write("WARN", msg, null);
    }

    public void error(String msg) {
        this.write("ERROR", msg, null);
    }

    public void error(String msg, Throwable t) {
        this.write("ERROR", msg, t);
    }

    public void debug(String msg) {
        this.write("DEBUG", msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String level, String msg, Throwable t) {
        this.lock.lock();
        try {
            File file = this.logFilePath.toFile();
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            if (file.exists() && file.length() > this.rotateBytes) {
                String ts = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                File rotated = new File(file.getParentFile(), file.getName() + "." + ts + ".1");
                if (!file.renameTo(rotated)) {
                    try (FileOutputStream os = new FileOutputStream(file, true);){
                        ((OutputStream)os).write(("\n--- ROTATE FAILED @ " + ts + " ---\n").getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            try (FileOutputStream os = new FileOutputStream(file, true);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
                 BufferedWriter bw = new BufferedWriter(osw);){
                String ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
                bw.write(ts + " [" + level + "] " + msg);
                bw.newLine();
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    bw.write(sw.toString());
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tailBytes(int maxBytes) {
        this.lock.lock();
        try {
            String string;
            File file = this.logFilePath.toFile();
            if (!file.exists()) {
                String string2 = "";
                return string2;
            }
            long len = file.length();
            long start = Math.max(0L, len - (long)maxBytes);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                raf.seek(start);
                byte[] buf = new byte[(int)(len - start)];
                raf.readFully(buf);
                string = new String(buf, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    String string3 = "";
                    return string3;
                }
            }
            raf.close();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Path getPath() {
        return this.logFilePath;
    }
}

