/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.depend;

import de.eztxm.luckprefix.LuckPrefix;
import de.eztxm.luckprefix.util.GroupManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.luckperms.api.LuckPerms;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckPrefixPlaceholderExtension
extends PlaceholderExpansion {
    private final Plugin plugin;

    public LuckPrefixPlaceholderExtension(Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "luckprefix";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        LuckPerms luckPerms = LuckPrefix.getInstance().getLuckPerms();
        GroupManager groupManager = LuckPrefix.getInstance().getGroupManager();
        String playerGroup = luckPerms.getUserManager().getUser(player.getUniqueId()).getPrimaryGroup().toLowerCase();
        switch (params.toLowerCase()) {
            case "prefix": {
                return groupManager.getPrefixByGroup().get(playerGroup);
            }
            case "suffix": {
                return groupManager.getSuffixByGroup().get(playerGroup);
            }
            case "tabformat": {
                return groupManager.getTabFormatByGroup().get(playerGroup);
            }
            case "chatformat": {
                return groupManager.getChatFormatByGroup().get(playerGroup);
            }
            case "sortid": {
                return groupManager.getSortIdByGroup().get(playerGroup);
            }
            case "namecolor": {
                return groupManager.getNameColorByGroup().get(playerGroup).toString();
            }
        }
        return null;
    }
}

