/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation.mixin;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.brigadier.Message;
import com.wulian.chatimpressiveanimation.config.ConfigUtil;
import com.wulian.chatimpressiveanimation.mixin.ChatHudAccessor;
import com.wulian.chatimpressiveanimation.mixin.ChatHudLineAccessor;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_408.class})
public class ChatScreenMixin {
    @Unique
    private boolean wasOpenedLastFrame = false;
    @Unique
    private boolean isClosing = false;
    @Unique
    private long animationStartTime = 0L;
    @Unique
    private float offsetY = 0.0f;
    private static final int FADE_TIME = ConfigUtil.getConfig().chatBarAnimationFadeTime;
    private static final float FADE_OFFSET = 10.0f;
    private static final float EASE_IN_OUT_FACTOR = 1.70158f;
    private static final float EASE_OUT_FACTOR = 2.70158f;
    public final class_310 client = class_310.method_1551();

    @Inject(method={"method_25394(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="HEAD")})
    private void renderStart(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatBarAnimation) {
            return;
        }
        if (this.client.field_1724 != null && !this.wasOpenedLastFrame && !this.client.field_1724.method_6113()) {
            this.wasOpenedLastFrame = true;
            this.animationStartTime = System.currentTimeMillis();
            this.isClosing = false;
        }
        float screenFactor = (float)this.client.method_22683().method_4507() / 1080.0f;
        float elapsedTime = System.currentTimeMillis() - this.animationStartTime;
        float alpha = this.isClosing ? elapsedTime / (float)FADE_TIME : 1.0f - elapsedTime / (float)FADE_TIME;
        alpha = Math.min(1.0f, Math.max(0.0f, alpha));
        float easedAlpha = 2.70158f * alpha * alpha * alpha - 1.70158f * alpha * alpha;
        this.offsetY = easedAlpha * 10.0f * screenFactor;
        context.method_51448().pushMatrix();
        context.method_51448().translate(0.0f, this.offsetY);
        if (this.isClosing) {
            GlStateManager._enableBlend();
        }
    }

    @Unique
    private boolean hasActiveChatMessages() {
        if (this.client.field_1705 == null || this.client.field_1705.method_1743() == null) {
            return false;
        }
        List<Message> messages = ((ChatHudAccessor)this.client.field_1705.method_1743()).getVisibleMessages();
        int ticks = this.client.field_1705.method_1738();
        int fadeTicks = 200;
        for (Message msg : messages) {
            class_303 line;
            int creationTick;
            if (!(msg instanceof class_303) || ticks - (creationTick = ((ChatHudLineAccessor)(line = (class_303)msg)).getCreationTick()) >= 200) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"method_25404(Lnet/minecraft/class_11908;)Z"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void onKeyPressed(class_11908 input, CallbackInfoReturnable<Boolean> cir) {
        if (input.comp_4795() == 256) {
            if (ConfigUtil.getConfig().enableChatBarAnimation && !this.hasActiveChatMessages()) {
                this.isClosing = true;
                this.animationStartTime = System.currentTimeMillis();
            } else {
                this.client.method_1507(null);
            }
            cir.cancel();
        }
    }

    @Inject(method={"method_25394(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="TAIL")})
    private void renderEnd(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatBarAnimation) {
            return;
        }
        context.method_51448().popMatrix();
        if (this.isClosing) {
            GlStateManager._disableBlend();
        }
        if (this.isClosing && System.currentTimeMillis() - this.animationStartTime >= (long)FADE_TIME) {
            this.client.method_1507(null);
        }
    }

    @Inject(method={"method_25432()V"}, at={@At(value="HEAD")})
    private void onClosed(CallbackInfo ci) {
        this.wasOpenedLastFrame = false;
    }
}

