/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation.neoforge.mixin;

import com.wulian.chatimpressiveanimation.ChatImpressiveAnimationExpectPlatform;
import com.wulian.chatimpressiveanimation.config.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ChatComponent.class})
public class ChatHudMixin {
    @Shadow
    private int chatScrollbarPos;
    @Shadow
    @Final
    private List<GuiMessage.Line> trimmedMessages;
    @Unique
    private final ArrayList<Long> messageTimestamps = new ArrayList();
    @Unique
    private final int chatSendingAnimationFadeTime;
    @Unique
    private int chatDisplacementY;

    public ChatHudMixin() {
        this.chatSendingAnimationFadeTime = ConfigUtil.getConfig().chatSendingAnimationFadeTime;
        this.chatDisplacementY = 0;
    }

    @Shadow
    private int getLineHeight() {
        return 0;
    }

    @Unique
    private void calculateYOffset() {
        try {
            int lineHeight = this.getLineHeight();
            float fadeOffsetYScale = 0.8f;
            float maxDisplacement = (float)lineHeight * fadeOffsetYScale;
            long timestamp = this.messageTimestamps.getFirst();
            long timeAlive = System.currentTimeMillis() - timestamp;
            this.chatDisplacementY = timeAlive < (long)this.chatSendingAnimationFadeTime && this.chatScrollbarPos == 0 ? (int)(maxDisplacement - (float)timeAlive / (float)this.chatSendingAnimationFadeTime * maxDisplacement) : 0;
        }
        catch (Exception ignored) {
            this.chatDisplacementY = 0;
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;IIIZZ)V"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics context, Font font, int currentTick, int mouseX, int mouseY, boolean focused, boolean open, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatSendingAnimation) {
            return;
        }
        this.calculateYOffset();
        float raisedOffset = 0.0f;
        Object object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            raisedOffset -= (float)distance.intValue();
        } else {
            object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:distance");
            if (object instanceof Integer) {
                Integer distance = (Integer)object;
                raisedOffset -= (float)distance.intValue();
            }
        }
        context.pose().translate(0.0f, (float)this.chatDisplacementY + raisedOffset);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;IIIZZ)V"}, at={@At(value="TAIL")})
    private void onRenderEnd(GuiGraphics context, Font font, int currentTick, int mouseX, int mouseY, boolean focused, boolean open, CallbackInfo ci) {
        float raisedOffset = 0.0f;
        Object object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            raisedOffset -= (float)distance.intValue();
        } else {
            object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:distance");
            if (object instanceof Integer) {
                Integer distance = (Integer)object;
                raisedOffset -= (float)distance.intValue();
            }
        }
        context.pose().translate(0.0f, -((float)this.chatDisplacementY + raisedOffset));
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="TAIL")})
    private void addMessage(Component message, MessageSignature signatureData, GuiMessageTag indicator, CallbackInfo ci) {
        this.messageTimestamps.addFirst(System.currentTimeMillis());
        while (this.messageTimestamps.size() > this.trimmedMessages.size()) {
            this.messageTimestamps.removeLast();
        }
    }
}

