/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.neoforged.fml.loading.FMLPaths;

public class ModConfig {
    private static ModConfig instance;
    private static final Gson GSON;
    private static final File CONFIG_FILE;
    public boolean enableMessageAnimation = true;
    public boolean enableTextFieldAnimation = true;
    public boolean removeMessageIndicator = true;
    public int fadeTimeMessage = 150;
    public int fadeTimeTextField = 170;

    public static ModConfig getConfig() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            instance = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.enableMessageAnimation = true;
        this.enableTextFieldAnimation = true;
        this.removeMessageIndicator = true;
        this.fadeTimeMessage = 150;
        this.fadeTimeTextField = 170;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = FMLPaths.CONFIGDIR.get().resolve("chat-animation.json").toFile();
    }
}

