/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.mixin;

import com.ezzenix.config.ModConfig;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public class ChatComponentMixin {
    @Shadow
    private int chatScrollbarPos;
    @Unique
    private long lastMessageTime = 0L;

    @Shadow
    private int getLineHeight() {
        return 0;
    }

    @Unique
    private float calculateDisplacement() {
        if (!ModConfig.getConfig().enableMessageAnimation || this.chatScrollbarPos != 0) {
            return 0.0f;
        }
        float fadeTime = ModConfig.getConfig().fadeTimeMessage;
        int lineHeight = this.getLineHeight();
        float fadeOffsetYScale = 0.8f;
        float maxDisplacement = (float)lineHeight * fadeOffsetYScale;
        long lifetime = System.currentTimeMillis() - this.lastMessageTime;
        float alpha = Math.min((float)lifetime / fadeTime, 1.0f);
        return maxDisplacement - alpha * maxDisplacement;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics context, int currentTick, int mouseX, int mouseY, boolean focused, CallbackInfo ci) {
        float displacement = this.calculateDisplacement();
        context.pose().pushMatrix();
        context.pose().translate(0.0f, displacement);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderEnd(GuiGraphics context, int currentTick, int mouseX, int mouseY, boolean focused, CallbackInfo ci) {
        context.pose().popMatrix();
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="TAIL")})
    private void addMessage(Component chatComponent, MessageSignature headerSignature, GuiMessageTag tag, CallbackInfo ci) {
        this.lastMessageTime = System.currentTimeMillis();
    }
}

