/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.chatanimation.config;

import com.ezzenix.chatanimation.config.ModConfig;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    Screen parentScreen;
    ModConfig config;

    public ModConfigScreen(Screen parentScreen) {
        super((Component)Component.literal((String)"Settings"));
        this.parentScreen = parentScreen;
        this.config = ModConfig.getConfig();
    }

    public static Screen create(Screen parentScreen) {
        return new ModConfigScreen(parentScreen);
    }

    protected void init() {
        int buttonWidth = 140;
        int buttonHeight = 20;
        int x = this.width / 2 - buttonWidth / 2;
        int y = this.height / 2 - buttonHeight / 2 - 75;
        int spacingX = 80;
        int spacingY = 25;
        this.addToggleOption(x - spacingX, y, buttonWidth, buttonHeight, "Animate Messages", () -> this.config.enableMessageAnimation, val -> {
            this.config.enableMessageAnimation = val;
        });
        this.addSliderOption(x - spacingX, y + spacingY, buttonWidth, buttonHeight, "Duration", 10, 300, () -> this.config.fadeTimeMessage, val -> {
            this.config.fadeTimeMessage = val;
        });
        this.addToggleOption(x - spacingX, y + spacingY * 2, buttonWidth, buttonHeight, "Hide Indicator", () -> this.config.removeMessageIndicator, val -> {
            this.config.removeMessageIndicator = val;
        });
        this.addToggleOption(x + spacingX, y, buttonWidth, buttonHeight, "Animate Open", () -> this.config.enableTextFieldAnimation, val -> {
            this.config.enableTextFieldAnimation = val;
        });
        this.addSliderOption(x + spacingX, y + spacingY, buttonWidth, buttonHeight, "Duration", 10, 700, () -> this.config.fadeTimeTextField, val -> {
            this.config.fadeTimeTextField = val;
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset").withStyle(ChatFormatting.RED), button -> {
            this.config.reset();
            this.clearWidgets();
            this.init();
        }).bounds(x - spacingX, y + spacingY * 5, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(null);
            }
        }).bounds(x + spacingX, y + spacingY * 5, buttonWidth, buttonHeight).build());
    }

    private void addToggleOption(int x, int y, int width, int height, String text, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        Button widget = Button.builder((Component)Component.literal((String)(text + ": ")).append((Component)(getter.get() != false ? Component.literal((String)"ON").withStyle(ChatFormatting.GREEN) : Component.literal((String)"OFF").withStyle(ChatFormatting.RED))), button -> {
            setter.accept((Boolean)getter.get() == false);
            button.setMessage((Component)Component.literal((String)(text + ": ")).append((Component)((Boolean)getter.get() != false ? Component.literal((String)"ON").withStyle(ChatFormatting.GREEN) : Component.literal((String)"OFF").withStyle(ChatFormatting.RED))));
        }).bounds(x, y, width, height).build();
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private void addSliderOption(int x, int y, int width, int height, final String label, final int min, final int max, Supplier<Integer> getter, final Consumer<Integer> setter) {
        int current = getter.get();
        double normalized = (double)(current - min) / (double)(max - min);
        AbstractSliderButton widget = new AbstractSliderButton(this, x, y, width, height, (Component)Component.literal((String)(label + ": " + String.valueOf(getter.get()) + "ms")), normalized){

            protected void updateMessage() {
                int valueInt = (int)(this.value * (double)(max - min)) + min;
                this.setMessage((Component)Component.literal((String)(label + ": " + valueInt + "ms")));
            }

            protected void applyValue() {
                int newValue = (int)(this.value * (double)(max - min)) + min;
                setter.accept(newValue);
            }
        };
        this.addRenderableWidget((GuiEventListener)widget);
    }

    public void removed() {
        this.config.save();
    }

    public void onClose() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen(this.parentScreen);
    }
}

