/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.chatanimation.mixin;

import com.ezzenix.chatanimation.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatScreen.class})
public class ChatScreenMixin {
    @Unique
    private boolean wasOpenedLastFrame = false;
    @Unique
    private long lastOpenTime = 0L;
    @Unique
    private float displacement = 0.0f;

    @Unique
    private float calculateDisplacement() {
        if (!ModConfig.getConfig().enableTextFieldAnimation) {
            return 0.0f;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ != null && !this.wasOpenedLastFrame && !client.f_91074_.m_5803_()) {
            this.wasOpenedLastFrame = true;
            this.lastOpenTime = System.currentTimeMillis();
        }
        float FADE_TIME = ModConfig.getConfig().fadeTimeTextField;
        float FADE_OFFSET = 8.0f;
        float screenFactor = (float)client.m_91268_().m_85442_() / 1080.0f;
        float timeSinceOpen = Math.min((float)(System.currentTimeMillis() - this.lastOpenTime), FADE_TIME);
        float alpha = 1.0f - timeSinceOpen / FADE_TIME;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        float modifiedAlpha = c3 * alpha * alpha * alpha - c1 * alpha * alpha;
        return modifiedAlpha * FADE_OFFSET * screenFactor;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", shift=At.Shift.BEFORE)})
    private void renderStart(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.displacement = this.calculateDisplacement();
        if (this.displacement != 0.0f) {
            context.m_280168_().m_85836_();
            context.m_280168_().m_252880_(0.0f, this.displacement, 0.0f);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    private void renderEnd(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.displacement != 0.0f) {
            context.m_280168_().m_85849_();
        }
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void onClosed(CallbackInfo ci) {
        this.wasOpenedLastFrame = false;
    }
}

