/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.gui;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.gui.OptionsToggleScreen;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class OptionsToggleList
extends ContainerObjectSelectionList<Entry> {
    private final String profileName;
    private final ProfileConfiguration profileConfiguration;
    private final EditBox searchBox;
    private final List<OptionEntry> allEntries = new ArrayList<OptionEntry>();

    public OptionsToggleList(OptionsToggleScreen optionsToggleScreen, Minecraft minecraft, String profileName, ProfileConfiguration profileConfiguration, EditBox searchBox) {
        super(minecraft, optionsToggleScreen.width, optionsToggleScreen.layout.getContentHeight(), optionsToggleScreen.layout.getHeaderHeight(), 20);
        this.profileConfiguration = profileConfiguration;
        this.profileName = profileName;
        this.searchBox = searchBox;
        this.searchBox.setResponder(this::filterEntries);
        this.refreshEntries(false, false);
    }

    private void filterEntries(String searchText) {
        this.clearEntries();
        if (searchText.isEmpty()) {
            this.allEntries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            return;
        }
        String filter = searchText.toLowerCase();
        this.allEntries.stream().filter(entry -> entry.key.toLowerCase().contains(filter)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public void refreshEntries(boolean overriding, boolean overrideToggle) {
        this.allEntries.clear();
        Path profile = Profiles.PROFILES_DIRECTORY.resolve(this.profileName);
        Path optionsFile = profile.resolve("options.txt");
        if (overriding && !overrideToggle) {
            this.profileConfiguration.setOptionsToLoad(new ArrayList<String>());
        }
        try (Stream<String> lines = Files.lines(optionsFile);){
            lines.forEach(line -> {
                String[] option = line.split(":");
                if (option.length > 1) {
                    if (overrideToggle) {
                        List<String> optionsToLoad = this.profileConfiguration.getOptionsToLoad();
                        optionsToLoad.add(option[0]);
                        this.profileConfiguration.setOptionsToLoad(optionsToLoad);
                    }
                    this.allEntries.add(new OptionEntry(option[0], option[1], this.profileConfiguration.getOptionsToLoad().contains(option[0])));
                } else {
                    this.allEntries.add(new OptionEntry(option[0], "", this.profileConfiguration.getOptionsToLoad().contains(option[0])));
                }
            });
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when listing options", (Throwable)e);
        }
        this.filterEntries(this.searchBox.getValue());
    }

    protected int scrollBarX() {
        return super.scrollBarX() + 15;
    }

    public int getRowWidth() {
        return 340;
    }

    public class OptionEntry
    extends Entry {
        private final String key;
        private final Component optionKey;
        private final CycleButton<Boolean> toggleButton;

        OptionEntry(String optionKey, String optionValue, boolean toggled) {
            this.key = optionKey;
            this.optionKey = Component.literal((String)optionKey);
            this.toggleButton = CycleButton.onOffBuilder((boolean)toggled).displayOnlyValue().create(0, 0, 44, 20, (Component)Component.empty(), (button, boolean_) -> {
                List<String> optionsToLoad = OptionsToggleList.this.profileConfiguration.getOptionsToLoad();
                if (boolean_.booleanValue()) {
                    button.setMessage((Component)button.getMessage().copy().withStyle(ChatFormatting.GREEN));
                    optionsToLoad.add(optionKey);
                } else {
                    button.setMessage((Component)button.getMessage().copy().withStyle(ChatFormatting.RED));
                    optionsToLoad.remove(optionKey);
                }
                OptionsToggleList.this.profileConfiguration.setOptionsToLoad(optionsToLoad);
            });
            this.toggleButton.setTooltip(Tooltip.create((Component)Component.literal((String)optionValue)));
            if (toggled) {
                this.toggleButton.setMessage((Component)this.toggleButton.getMessage().copy().withStyle(ChatFormatting.GREEN));
            } else {
                this.toggleButton.setMessage((Component)this.toggleButton.getMessage().copy().withStyle(ChatFormatting.RED));
            }
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font fontRenderer = ((OptionsToggleList)OptionsToggleList.this).minecraft.font;
            int posX = OptionsToggleList.this.scrollBarX() - this.toggleButton.getWidth() - 10;
            int posY = y - 2;
            int textY = y + entryHeight / 2;
            guiGraphics.drawString(fontRenderer, this.optionKey, x, textY - 4, -1);
            this.toggleButton.setPosition(posX, posY);
            this.toggleButton.render(guiGraphics, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of(this.toggleButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of(this.toggleButton);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

