/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.gui;

import com.google.common.collect.ImmutableList;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.gui.EditProfileScreen;
import net.trafficlunar.optionsprofiles.gui.ProfilesScreen;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class ProfilesList
extends ContainerObjectSelectionList<ProfileEntry> {
    private final ProfilesScreen profilesScreen;

    public ProfilesList(ProfilesScreen profilesScreen, Minecraft minecraft) {
        super(minecraft, profilesScreen.width, profilesScreen.layout.getContentHeight(), profilesScreen.layout.getHeaderHeight(), 20);
        this.profilesScreen = profilesScreen;
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.clearEntries();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Profiles.PROFILES_DIRECTORY);){
            ArrayList<Path> profileList = new ArrayList<Path>();
            for (Path profile : directoryStream) {
                if (!Files.isDirectory(profile, new LinkOption[0])) continue;
                profileList.add(profile);
            }
            profileList.sort(Comparator.comparing(p -> p.getFileName().toString()));
            for (Path profile : profileList) {
                this.addEntry((AbstractSelectionList.Entry)new ProfileEntry((Component)Component.literal((String)profile.getFileName().toString())));
            }
        }
        catch (Exception e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when listing profiles", (Throwable)e);
        }
    }

    protected int scrollBarX() {
        return super.scrollBarX() + 15;
    }

    public int getRowWidth() {
        return 340;
    }

    public class ProfileEntry
    extends ContainerObjectSelectionList.Entry<ProfileEntry> {
        private final Component profileName;
        private final Button editButton;
        private final Button loadButton;

        ProfileEntry(Component profileName) {
            this.profileName = profileName;
            this.editButton = Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.edit-profile"), button -> ProfilesList.this.minecraft.setScreen((Screen)new EditProfileScreen(ProfilesList.this.profilesScreen, profileName))).size(75, 20).build();
            this.loadButton = Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.load-profile"), button -> {
                Profiles.loadProfile(profileName.getString());
                OptionsProfilesMod.LOGGER.warn("[Profile '{}']: Loaded through button", (Object)profileName);
            }).size(75, 20).build();
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font fontRenderer = ((ProfilesList)ProfilesList.this).minecraft.font;
            int posX = ProfilesList.this.scrollBarX() - this.loadButton.getWidth() - 10;
            int posY = y - 2;
            int textY = y + entryHeight / 2;
            guiGraphics.drawString(fontRenderer, this.profileName, x, textY - 4, -1);
            this.editButton.setPosition(posX - this.editButton.getWidth(), posY);
            this.editButton.render(guiGraphics, mouseX, mouseY, tickDelta);
            this.loadButton.setPosition(posX, posY);
            this.loadButton.render(guiGraphics, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }
    }
}

