/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class Keybinds {
    private static final KeyMapping[] PROFILE_KEYMAPPINGS = new KeyMapping[3];

    public static void init() {
        KeyMapping.Category category = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"optionsprofiles", (String)"keys"));
        for (int i = 0; i < PROFILE_KEYMAPPINGS.length; ++i) {
            Keybinds.PROFILE_KEYMAPPINGS[i] = new KeyMapping("key.optionsprofiles.profile_" + (i + 1), InputConstants.Type.KEYSYM, -1, category);
            KeyMappingRegistry.register((KeyMapping)PROFILE_KEYMAPPINGS[i]);
        }
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            for (int i = 0; i < PROFILE_KEYMAPPINGS.length; ++i) {
                while (PROFILE_KEYMAPPINGS[i].consumeClick()) {
                    Keybinds.loadProfilesByKeybind(i + 1);
                }
            }
        });
    }

    private static void loadProfilesByKeybind(int keybindIndex) {
        try (Stream<Path> paths = Files.list(Profiles.PROFILES_DIRECTORY);){
            paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                String profileName = path.getFileName().toString();
                ProfileConfiguration profileConfiguration = ProfileConfiguration.get(profileName);
                if (profileConfiguration.getKeybindIndex() == keybindIndex) {
                    Profiles.loadProfile(profileName);
                    OptionsProfilesMod.LOGGER.warn("[Profile '{}']: Loaded through keybind", (Object)profileName);
                }
            });
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when loading profiles through keybinds", (Throwable)e);
        }
    }
}

