/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class OptionsProfilesModConfiguration {
    private static Path configurationFile;
    private boolean showProfilesButton = true;

    public OptionsProfilesModConfiguration save() {
        OptionsProfilesModConfiguration configuration = new OptionsProfilesModConfiguration();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(configurationFile, new OpenOption[0]);){
            gson.toJson((Object)this, (Appendable)writer);
            OptionsProfilesMod.LOGGER.info("Main configuration saved");
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("Unable to write main configuration.json!", (Throwable)e);
        }
        return configuration;
    }

    public static OptionsProfilesModConfiguration load() {
        OptionsProfilesModConfiguration configuration = new OptionsProfilesModConfiguration();
        configurationFile = Profiles.PROFILES_DIRECTORY.resolve("configuration.json");
        if (Files.notExists(configurationFile, new LinkOption[0])) {
            configuration.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(configurationFile);){
            Gson gson = new Gson();
            configuration = (OptionsProfilesModConfiguration)gson.fromJson((Reader)reader, OptionsProfilesModConfiguration.class);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when reading the main configuration.json", (Throwable)e);
        }
        return configuration;
    }

    public boolean shouldShowProfilesButton() {
        return this.showProfilesButton;
    }

    public void setShowProfilesButton(boolean showProfilesButton) {
        this.showProfilesButton = showProfilesButton;
    }
}

