/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.trafficlunar.optionsprofiles.gui.OptionsToggleScreen;
import net.trafficlunar.optionsprofiles.gui.ProfilesScreen;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class EditProfileScreen
extends Screen {
    private final ProfilesScreen profilesScreen;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 24, 33);
    private final Component profileName;
    private final ProfileConfiguration profileConfiguration;
    private EditBox profileNameEdit;

    public EditProfileScreen(ProfilesScreen profilesScreen, Component profileName) {
        super((Component)Component.literal((String)(Component.translatable((String)"gui.optionsprofiles.editing-profile-title").getString() + profileName.getString())));
        this.profilesScreen = profilesScreen;
        this.profileName = profileName;
        this.profileConfiguration = ProfileConfiguration.get(profileName.getString());
    }

    protected void init() {
        LinearLayout linearLayoutHeader = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical());
        linearLayoutHeader.addChild((LayoutElement)new StringWidget(this.title, this.font), LayoutSettings::alignHorizontallyCenter);
        this.profileNameEdit = new EditBox(this.font, this.width / 2 - 102, 116, 204, 20, (Component)Component.empty());
        this.profileNameEdit.setValue(this.profileName.getString());
        LinearLayout linearLayoutContent = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical().spacing(12), LayoutSettings::alignHorizontallyCenter);
        LinearLayout linearLayoutEditBox = (LinearLayout)linearLayoutContent.addChild((LayoutElement)LinearLayout.vertical().spacing(6), LayoutSettings::alignHorizontallyCenter);
        linearLayoutEditBox.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"gui.optionsprofiles.profile-name-text"), this.font), LayoutSettings::alignHorizontallyCenter);
        linearLayoutEditBox.addChild((LayoutElement)this.profileNameEdit);
        LinearLayout linearLayoutButtons = (LinearLayout)linearLayoutContent.addChild((LayoutElement)LinearLayout.vertical().spacing(1), LayoutSettings::alignHorizontallyCenter);
        linearLayoutButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.overwrite-options"), button -> {
            Profiles.writeProfile(this.profileName.getString(), true);
            this.onClose();
        }).size(150, 20).pos(this.width / 2 - 75, 145).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.optionsprofiles.overwrite-options.tooltip"))).build(), LayoutSettings::alignHorizontallyCenter);
        linearLayoutButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.rename-profile"), button -> {
            Profiles.renameProfile(this.profileName.getString(), this.profileNameEdit.getValue());
            this.minecraft.setScreen((Screen)new EditProfileScreen(this.profilesScreen, (Component)Component.literal((String)this.profileNameEdit.getValue())));
        }).size(150, 20).pos(this.width / 2 - 75, 166).build(), LayoutSettings::alignHorizontallyCenter);
        linearLayoutButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.options-toggle").append("..."), button -> this.minecraft.setScreen((Screen)new OptionsToggleScreen(this, this.profileName, this.profileConfiguration))).size(150, 20).pos(this.width / 2 - 75, 187).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.optionsprofiles.options-toggle.tooltip"))).build(), LayoutSettings::alignHorizontallyCenter);
        LinearLayout linearLayoutSettings = (LinearLayout)linearLayoutContent.addChild((LayoutElement)LinearLayout.vertical().spacing(1), LayoutSettings::alignHorizontallyCenter);
        linearLayoutSettings.addChild((LayoutElement)CycleButton.builder(value -> Component.literal((String)value.toString())).withValues((Object[])new Integer[]{0, 1, 2, 3}).withInitialValue((Object)this.profileConfiguration.getKeybindIndex()).create(0, 0, 150, 20, (Component)Component.translatable((String)"gui.optionsprofiles.keybind-index"), (button, keybindIndex) -> this.profileConfiguration.setKeybindIndex((int)keybindIndex)), LayoutSettings::alignHorizontallyCenter);
        linearLayoutSettings.addChild((LayoutElement)CycleButton.onOffBuilder((boolean)this.profileConfiguration.shouldLoadOnStartup()).create(0, 0, 150, 20, (Component)Component.translatable((String)"gui.optionsprofiles.load-on-startup"), (button, boolean_) -> this.profileConfiguration.setLoadOnStartup((boolean)boolean_)), LayoutSettings::alignHorizontallyCenter);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
        this.layout.addToFooter((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.optionsprofiles.delete-profile").withStyle(ChatFormatting.RED), button -> {
            Profiles.deleteProfile(this.profileName.getString());
            this.onClose(true);
        }).width(50).build(), layoutSettings -> layoutSettings.alignHorizontallyLeft().paddingLeft(5));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void onClose() {
        this.onClose(false);
    }

    public void onClose(boolean deleted) {
        if (!deleted) {
            this.profileConfiguration.save();
        }
        this.minecraft.setScreen((Screen)this.profilesScreen);
        this.profilesScreen.profilesList.refreshEntries();
    }
}

