/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.profiles.loaders;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;

public class IrisLoader {
    public static void load(Path file) {
        try (FileReader reader = new FileReader(file.toFile());){
            Properties properties = new Properties();
            properties.load(reader);
            IrisLoader.apply(properties);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when reading and loading Iris's configuration", (Throwable)e);
        }
    }

    private static void apply(Properties properties) {
        Iris.getIrisConfig().setShaderPackName(properties.getProperty("shaderPack"));
        Iris.getIrisConfig().setDebugEnabled("true".equals(properties.getProperty("enableDebugOptions")));
        IrisApi.getInstance().getConfig().setShadersEnabledAndApply("true".equals(properties.getProperty("enableShaders")));
        try {
            Iris.getIrisConfig().save();
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when loading Sodium's configuration", (Throwable)e);
        }
    }
}

