/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.trafficlunar.optionsprofiles.Commands;
import net.trafficlunar.optionsprofiles.Keybinds;
import net.trafficlunar.optionsprofiles.OptionsProfilesModConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptionsProfilesMod {
    public static final String MOD_ID = "optionsprofiles";
    public static final Logger LOGGER = LogManager.getLogger((String)"Options Profiles");
    private static OptionsProfilesModConfiguration CONFIG;

    public static void init() {
        Path profilesDirectory = Paths.get("options-profiles", new String[0]);
        if (Files.notExists(profilesDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(profilesDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when creating the 'options-profiles' directory.", (Throwable)e);
            }
        }
        CONFIG = OptionsProfilesModConfiguration.load();
        ClientLifecycleEvent.CLIENT_STARTED.register(client -> Profiles.init());
        Keybinds.init();
        Commands.init();
    }

    public static OptionsProfilesModConfiguration config() {
        if (CONFIG == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return CONFIG;
    }
}

