/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.gui;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.gui.OptionsToggleScreen;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class OptionsToggleList
extends class_4265<OptionEntry> {
    private final String profileName;
    private final ProfileConfiguration profileConfiguration;

    public OptionsToggleList(OptionsToggleScreen optionsToggleScreen, class_310 minecraft, String profileName, ProfileConfiguration profileConfiguration) {
        super(minecraft, optionsToggleScreen.field_22789, optionsToggleScreen.field_49503.method_57727(), optionsToggleScreen.field_49503.method_48998(), 20);
        this.profileConfiguration = profileConfiguration;
        this.profileName = profileName;
        this.refreshEntries(false, false);
    }

    public void refreshEntries(boolean overriding, boolean overrideToggle) {
        this.method_25339();
        Path profile = Profiles.PROFILES_DIRECTORY.resolve(this.profileName);
        Path optionsFile = profile.resolve("options.txt");
        if (overriding && !overrideToggle) {
            this.profileConfiguration.setOptionsToLoad(new ArrayList<String>());
        }
        try (Stream<String> lines = Files.lines(optionsFile);){
            lines.forEach(line -> {
                String[] option = line.split(":");
                if (option.length > 1) {
                    if (overrideToggle) {
                        List<String> optionsToLoad = this.profileConfiguration.getOptionsToLoad();
                        optionsToLoad.add(option[0]);
                        this.profileConfiguration.setOptionsToLoad(optionsToLoad);
                    }
                    this.method_25321((class_350.class_351)new OptionEntry(option[0], option[1], this.profileConfiguration.getOptionsToLoad().contains(option[0])));
                } else {
                    this.method_25321((class_350.class_351)new OptionEntry(option[0], "", this.profileConfiguration.getOptionsToLoad().contains(option[0])));
                }
            });
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when listing options", (Throwable)e);
        }
    }

    protected int method_65507() {
        return super.method_65507() + 15;
    }

    public int method_25322() {
        return 340;
    }

    public class OptionEntry
    extends class_4265.class_4266<OptionEntry> {
        private final class_2561 optionKey;
        private final class_5676<Boolean> toggleButton;

        OptionEntry(String optionKey, String optionValue, boolean toggled) {
            this.optionKey = class_2561.method_43470((String)optionKey);
            this.toggleButton = class_5676.method_32613((boolean)toggled).method_32616().method_32617(0, 0, 44, 20, (class_2561)class_2561.method_43473(), (button, boolean_) -> {
                List<String> optionsToLoad = OptionsToggleList.this.profileConfiguration.getOptionsToLoad();
                if (boolean_.booleanValue()) {
                    button.method_25355((class_2561)button.method_25369().method_27661().method_27692(class_124.field_1060));
                    optionsToLoad.add(optionKey);
                } else {
                    button.method_25355((class_2561)button.method_25369().method_27661().method_27692(class_124.field_1061));
                    optionsToLoad.remove(optionKey);
                }
                OptionsToggleList.this.profileConfiguration.setOptionsToLoad(optionsToLoad);
            });
            this.toggleButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)optionValue)));
            if (toggled) {
                this.toggleButton.method_25355((class_2561)this.toggleButton.method_25369().method_27661().method_27692(class_124.field_1060));
            } else {
                this.toggleButton.method_25355((class_2561)this.toggleButton.method_25369().method_27661().method_27692(class_124.field_1061));
            }
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int posX = OptionsToggleList.this.method_65507() - this.toggleButton.method_25368() - 10;
            int posY = this.method_73382() - 2;
            this.toggleButton.method_48229(posX, posY);
            this.toggleButton.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            guiGraphics.method_27535(((OptionsToggleList)OptionsToggleList.this).field_22740.field_1772, this.optionKey, this.method_73380(), this.method_73385() - 4, -1);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of(this.toggleButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of(this.toggleButton);
        }
    }
}

