/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.gui;

import com.google.common.collect.ImmutableList;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.gui.EditProfileScreen;
import net.trafficlunar.optionsprofiles.gui.ProfilesScreen;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class ProfilesList
extends class_4265<ProfileEntry> {
    private final ProfilesScreen profilesScreen;

    public ProfilesList(ProfilesScreen profilesScreen, class_310 minecraft) {
        super(minecraft, profilesScreen.field_22789, profilesScreen.field_49503.method_57727(), profilesScreen.field_49503.method_48998(), 20);
        this.profilesScreen = profilesScreen;
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.method_25339();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Profiles.PROFILES_DIRECTORY);){
            ArrayList<Path> profileList = new ArrayList<Path>();
            for (Path profile : directoryStream) {
                if (!Files.isDirectory(profile, new LinkOption[0])) continue;
                profileList.add(profile);
            }
            profileList.sort(Comparator.comparing(p -> p.getFileName().toString()));
            for (Path profile : profileList) {
                this.method_25321((class_350.class_351)new ProfileEntry((class_2561)class_2561.method_43470((String)profile.getFileName().toString())));
            }
        }
        catch (Exception e) {
            OptionsProfilesMod.LOGGER.error("An error occurred when listing profiles", (Throwable)e);
        }
    }

    protected int method_65507() {
        return super.method_65507() + 15;
    }

    public int method_25322() {
        return 340;
    }

    public class ProfileEntry
    extends class_4265.class_4266<ProfileEntry> {
        private final class_2561 profileName;
        private final class_4185 editButton;
        private final class_4185 loadButton;

        ProfileEntry(class_2561 profileName) {
            this.profileName = profileName;
            this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.optionsprofiles.edit-profile"), button -> ProfilesList.this.field_22740.method_1507((class_437)new EditProfileScreen(ProfilesList.this.profilesScreen, profileName))).method_46437(75, 20).method_46431();
            this.loadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.optionsprofiles.load-profile"), button -> {
                Profiles.loadProfile(profileName.getString());
                ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1636();
                if (ProfileConfiguration.get(profileName.getString()).getOptionsToLoad().contains("resourcePacks")) {
                    ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1627(ProfilesList.this.field_22740.method_1520());
                    ProfilesList.this.field_22740.method_1521();
                }
                ((ProfilesList)ProfilesList.this).field_22740.field_1690.method_1640();
                ((ProfilesList)ProfilesList.this).field_22740.field_1769.method_3279();
            }).method_46437(75, 20).method_46431();
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int posX = ProfilesList.this.method_65507() - this.loadButton.method_25368() - 10;
            int posY = this.method_73382() - 2;
            this.editButton.method_48229(posX - this.editButton.method_25368(), posY);
            this.editButton.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            this.loadButton.method_48229(posX, posY);
            this.loadButton.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            guiGraphics.method_27535(((ProfilesList)ProfilesList.this).field_22740.field_1772, this.profileName, this.method_73380(), this.method_73385() - 4, -1);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.editButton, (Object)this.loadButton);
        }
    }
}

