/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.profiles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.profiles.Profiles;

public class ProfileConfiguration {
    private static Path configurationFile;
    private static String profileName;
    private boolean loadOnStartup = false;
    private int keybindIndex = 0;
    private List<String> optionsToLoad = new ArrayList<String>();

    public ProfileConfiguration save() {
        ProfileConfiguration configuration = new ProfileConfiguration();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(configurationFile, new OpenOption[0]);){
            gson.toJson((Object)this, (Appendable)writer);
            OptionsProfilesMod.LOGGER.info("[Profile '{}']: Profile configuration saved", (Object)profileName);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("Unable to write configuration.json to profile!", (Throwable)e);
        }
        return configuration;
    }

    public static ProfileConfiguration get(String profile_name) {
        ProfileConfiguration configuration = new ProfileConfiguration();
        configurationFile = Profiles.PROFILES_DIRECTORY.resolve(profile_name).resolve("configuration.json");
        profileName = profile_name;
        if (Files.notExists(configurationFile, new LinkOption[0])) {
            configuration.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(configurationFile);){
            Gson gson = new Gson();
            configuration = (ProfileConfiguration)gson.fromJson((Reader)reader, ProfileConfiguration.class);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when reading configuration.json", (Object)profileName, (Object)e);
        }
        return configuration;
    }

    public boolean shouldLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public int getKeybindIndex() {
        return this.keybindIndex;
    }

    public void setKeybindIndex(int keybindIndex) {
        this.keybindIndex = keybindIndex;
    }

    public List<String> getOptionsToLoad() {
        return this.optionsToLoad;
    }

    public void setOptionsToLoad(List<String> optionsToLoad) {
        this.optionsToLoad = optionsToLoad;
    }
}

