/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_2535;
import net.minecraft.class_746;
import net.trafficlunar.optionsprofiles.Commands;
import net.trafficlunar.optionsprofiles.Keybinds;
import net.trafficlunar.optionsprofiles.OptionsProfilesModConfiguration;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.Profiles;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptionsProfilesMod {
    public static final String MOD_ID = "optionsprofiles";
    public static final Logger LOGGER = LogManager.getLogger((String)"Options Profiles");
    private static OptionsProfilesModConfiguration CONFIG;

    public static void init() {
        Path profilesDirectory = Paths.get("options-profiles", new String[0]);
        if (Files.notExists(profilesDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(profilesDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when creating the 'options-profiles' directory.", (Throwable)e);
            }
        }
        CONFIG = OptionsProfilesModConfiguration.load();
        ClientLifecycleEvent.CLIENT_STARTED.register(client -> {
            try (Stream<Path> paths = Files.list(Profiles.PROFILES_DIRECTORY);){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                    String profileName = path.getFileName().toString();
                    ProfileConfiguration profileConfiguration = ProfileConfiguration.get(profileName);
                    if (profileConfiguration.shouldLoadOnStartup()) {
                        Profiles.loadProfile(profileName);
                        LOGGER.info("[Profile '{}']: Loaded on startup", (Object)profileName);
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when initializing", (Throwable)e);
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> OptionsProfilesMod.handleClientPlayerEvent(player, false));
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> OptionsProfilesMod.handleClientPlayerEvent(player, true));
        Keybinds.init();
        Commands.init();
    }

    public static OptionsProfilesModConfiguration config() {
        if (CONFIG == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return CONFIG;
    }

    private static void handleClientPlayerEvent(class_746 player, boolean isOnLeave) {
        SocketAddress address;
        if (player == null) {
            return;
        }
        class_2535 connection = player.field_3944.method_48296();
        if (!connection.method_10756() && (address = connection.method_10755()) instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String ip = inetAddress.getHostString().trim();
            try (Stream<Path> paths = Files.list(Profiles.PROFILES_DIRECTORY);){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                    String profileName = path.getFileName().toString();
                    ProfileConfiguration profileConfiguration = ProfileConfiguration.get(profileName);
                    String[] servers = profileConfiguration.getServers().split(",");
                    if (servers.length == 0) {
                        return;
                    }
                    if (Arrays.asList(servers).contains(isOnLeave ? "leave" : ip)) {
                        Profiles.loadProfile(profileName);
                        LOGGER.info("[Profile '{}']: Loaded on server ({})" + (isOnLeave ? "leave" : ""), (Object)profileName, (Object)ip);
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when initializing", (Throwable)e);
            }
        }
    }
}

