/*
 * Decompiled with CFR 0.152.
 */
package net.trafficlunar.optionsprofiles.profiles;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_310;
import net.trafficlunar.optionsprofiles.OptionsProfilesMod;
import net.trafficlunar.optionsprofiles.profiles.ProfileConfiguration;
import net.trafficlunar.optionsprofiles.profiles.loaders.DistantHorizonsLoader;
import net.trafficlunar.optionsprofiles.profiles.loaders.IrisLoader;
import net.trafficlunar.optionsprofiles.profiles.loaders.SodiumExtraLoader;
import net.trafficlunar.optionsprofiles.profiles.loaders.SodiumLoader;
import org.apache.commons.io.FileUtils;

public class Profiles {
    public static final Path PROFILES_DIRECTORY = Paths.get("options-profiles/", new String[0]);
    public static final Path OPTIONS_FILE = Paths.get("options.txt", new String[0]);
    public static final Path OPTIFINE_OPTIONS_FILE = Paths.get("optionsof.txt", new String[0]);
    public static final Path SODIUM_OPTIONS_FILE = Paths.get("config/sodium-options.json", new String[0]);
    public static final Path SODIUM_EXTRA_OPTIONS_FILE = Paths.get("config/sodium-extra-options.json", new String[0]);
    public static final Path IRIS_OPTIONS_FILE = Paths.get("config/iris.properties", new String[0]);
    public static final Path DISTANT_HORIZONS_OPTIONS_FILE = Paths.get("config/DistantHorizons.toml", new String[0]);

    public static void createProfile() {
        Object profileName = "Profile 1";
        Path profile = PROFILES_DIRECTORY.resolve((String)profileName);
        int i = 1;
        while (Files.exists(profile, new LinkOption[0])) {
            profileName = "Profile " + i;
            profile = Paths.get(PROFILES_DIRECTORY.toString(), new String[]{profileName});
            ++i;
        }
        try {
            Files.createDirectory(profile, new FileAttribute[0]);
            if (Files.exists(profile, new LinkOption[0])) {
                OptionsProfilesMod.LOGGER.info("[Profile '{}']: created", profileName);
                Profiles.writeProfile((String)profileName, false);
            } else {
                OptionsProfilesMod.LOGGER.warn("[Profile '{}']: Profile already exists?", profileName);
            }
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when creating a profile", profileName, (Object)e);
        }
    }

    private static void copyOptionFile(Path profile, Path options) {
        if (Files.exists(options, new LinkOption[0])) {
            Path profileOptions = profile.resolve(options.getFileName());
            try {
                Files.copy(options, profileOptions, new CopyOption[0]);
                OptionsProfilesMod.LOGGER.info("[Profile '{}']: Copied file '{}'", (Object)profile.getFileName().toString(), (Object)options.getFileName().toString());
            }
            catch (IOException e) {
                OptionsProfilesMod.LOGGER.error("[Profile '{}']: Unable to copy '{}'", (Object)profile.getFileName().toString(), (Object)options.getFileName().toString(), (Object)e);
            }
        }
    }

    public static void writeProfile(String profileName, boolean overwriting) {
        Path profile = PROFILES_DIRECTORY.resolve(profileName);
        Path profileOptions = profile.resolve("options.txt");
        if (overwriting) {
            try (Stream<Path> files = Files.list(profile);){
                files.filter(file -> !file.getFileName().toString().equals("configuration.json")).forEach(file -> {
                    try {
                        Files.delete(file);
                        OptionsProfilesMod.LOGGER.info("[Profile '{}']: Deleted file '{}'", (Object)profileName, (Object)file.getFileName().toString());
                    }
                    catch (IOException e) {
                        OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when trying to delete the file '{}'", (Object)profileName, (Object)file.getFileName().toString(), (Object)e);
                    }
                });
            }
            catch (IOException e) {
                OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when deleting old options files.", (Object)profileName, (Object)e);
            }
        }
        Profiles.copyOptionFile(profile, OPTIONS_FILE);
        Profiles.copyOptionFile(profile, OPTIFINE_OPTIONS_FILE);
        if (Platform.isModLoaded((String)"sodium")) {
            Profiles.copyOptionFile(profile, SODIUM_OPTIONS_FILE);
        }
        if (Platform.isModLoaded((String)"sodium-extra")) {
            Profiles.copyOptionFile(profile, SODIUM_EXTRA_OPTIONS_FILE);
        }
        if (Platform.isModLoaded((String)"iris")) {
            Profiles.copyOptionFile(profile, IRIS_OPTIONS_FILE);
        }
        if (Platform.isModLoaded((String)"distanthorizons")) {
            Profiles.copyOptionFile(profile, DISTANT_HORIZONS_OPTIONS_FILE);
        }
        if (!overwriting) {
            ProfileConfiguration profileConfiguration = ProfileConfiguration.get(profileName);
            try (Stream<String> lines = Files.lines(profileOptions);){
                List<String> optionsToLoad = profileConfiguration.getOptionsToLoad();
                lines.forEach(line -> {
                    String[] option = line.split(":");
                    optionsToLoad.add(option[0]);
                });
                profileConfiguration.save();
            }
            catch (IOException e) {
                OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when adding options to the configuration file", (Object)profileName, (Object)e);
            }
        }
    }

    private static void loadOptionFile(String profileName, Path options) {
        ProfileConfiguration profileConfiguration = ProfileConfiguration.get(profileName);
        Path profile = PROFILES_DIRECTORY.resolve(profileName);
        Path profileOptions = profile.resolve(options.getFileName());
        if (Files.exists(profileOptions, new LinkOption[0])) {
            if (options.getFileName().toString().equals("options.txt")) {
                Stream<String> lines;
                HashMap optionsToWrite = new HashMap();
                try {
                    lines = Files.lines(options);
                    try {
                        lines.forEach(line -> {
                            String[] option = line.split(":");
                            if (option.length > 1) {
                                optionsToWrite.put(option[0], option[1]);
                            } else {
                                optionsToWrite.put(option[0], "");
                            }
                        });
                    }
                    finally {
                        if (lines != null) {
                            lines.close();
                        }
                    }
                }
                catch (IOException e) {
                    OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred reading options.txt to load the profile", (Object)profileName, (Object)e);
                }
                try {
                    lines = Files.lines(profileOptions);
                    try {
                        lines.forEach(line -> {
                            String[] option = line.split(":");
                            if (option.length > 1 && profileConfiguration.getOptionsToLoad().contains(option[0])) {
                                optionsToWrite.put(option[0], option[1]);
                            }
                        });
                    }
                    finally {
                        if (lines != null) {
                            lines.close();
                        }
                    }
                }
                catch (IOException e) {
                    OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred reading profile options.txt to load the profile", (Object)profileName, (Object)e);
                }
                try {
                    Files.write(options, () -> optionsToWrite.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).iterator(), new OpenOption[0]);
                    OptionsProfilesMod.LOGGER.info("[Profile '{}']: '{}' loaded with specific options", (Object)profileName, (Object)options.getFileName());
                }
                catch (IOException e) {
                    OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred writing hashmap into options.txt", (Object)profileName, (Object)e);
                }
                return;
            }
            try {
                Files.copy(profileOptions, options, StandardCopyOption.REPLACE_EXISTING);
                OptionsProfilesMod.LOGGER.info("[Profile '{}']: '{}' loaded by copying", (Object)profileName, (Object)options.getFileName());
            }
            catch (IOException e) {
                OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when loading the profile", (Object)profileName, (Object)e);
            }
        }
    }

    private static void loadOptionFile(String profileName, Path options, Consumer<Path> loader) {
        Path profile = PROFILES_DIRECTORY.resolve(profileName);
        Path profileOptions = profile.resolve(options.getFileName());
        if (Files.exists(profileOptions, new LinkOption[0])) {
            loader.accept(profileOptions);
            OptionsProfilesMod.LOGGER.info("[Profile '{}']: '{}' loaded using loader class", (Object)profileName, (Object)options.getFileName());
        }
    }

    public static void loadProfile(String profileName) {
        Profiles.loadOptionFile(profileName, OPTIONS_FILE);
        Profiles.loadOptionFile(profileName, OPTIFINE_OPTIONS_FILE);
        if (Platform.isModLoaded((String)"sodium")) {
            Profiles.loadOptionFile(profileName, SODIUM_OPTIONS_FILE, SodiumLoader::load);
        }
        if (Platform.isModLoaded((String)"sodium-extra")) {
            Profiles.loadOptionFile(profileName, SODIUM_EXTRA_OPTIONS_FILE, SodiumExtraLoader::load);
        }
        if (Platform.isModLoaded((String)"iris")) {
            Profiles.loadOptionFile(profileName, IRIS_OPTIONS_FILE, IrisLoader::load);
        }
        if (Platform.isModLoaded((String)"distanthorizons")) {
            Profiles.loadOptionFile(profileName, DISTANT_HORIZONS_OPTIONS_FILE);
            Profiles.loadOptionFile(profileName, DISTANT_HORIZONS_OPTIONS_FILE, DistantHorizonsLoader::load);
        }
        class_310 minecraft = class_310.method_1551();
        minecraft.field_1690.method_1636();
        if (ProfileConfiguration.get(profileName).getOptionsToLoad().contains("resourcePacks")) {
            minecraft.field_1690.method_1627(minecraft.method_1520());
            minecraft.method_1521();
        }
        minecraft.field_1690.method_1640();
        minecraft.field_1769.method_3279();
    }

    public static void renameProfile(String profileName, String newProfileName) {
        Path profile = PROFILES_DIRECTORY.resolve(profileName);
        Path newProfile = PROFILES_DIRECTORY.resolve(newProfileName);
        if (Files.exists(newProfile, new LinkOption[0])) {
            OptionsProfilesMod.LOGGER.warn("[Profile '{}']: A profile with that name already exists!", (Object)profileName);
            return;
        }
        try {
            Files.move(profile, newProfile, new CopyOption[0]);
            OptionsProfilesMod.LOGGER.info("[Profile '{}']: renamed. Old name: {}", (Object)newProfileName, (Object)profileName);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("[Profile '{}']: An error occurred when renaming the profile", (Object)profileName, (Object)e);
        }
    }

    public static void deleteProfile(String profileName) {
        Path profile = PROFILES_DIRECTORY.resolve(profileName);
        try {
            FileUtils.deleteDirectory((File)profile.toFile());
            OptionsProfilesMod.LOGGER.info("[Profile '{}']: deleted", (Object)profileName);
        }
        catch (IOException e) {
            OptionsProfilesMod.LOGGER.error("[Profile '{}']: Profile was not deleted", (Object)profileName, (Object)e);
        }
    }
}

