package me.axieum.mcmod.minecord.impl.placeholder;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import me.axieum.mcmod.minecord.api.util.StringUtils;
import net.minecraft.class_2960;

import static me.axieum.mcmod.minecord.impl.MinecordImpl.getConfig;

/**
 * {@link eu.pb4.placeholders.api.Placeholders Placeholder API} global placeholders for Minecord API.
 */
public final class MinecordPlaceholders
{
    private MinecordPlaceholders() {}

    /**
     * Registers Minecord API global placeholders with {@link eu.pb4.placeholders.api.Placeholders Placeholder API}.
     */
    public static void register()
    {
        // minecord:player (or server)
        Placeholders.register(class_2960.method_60655("minecord", "player"), (ctx, arg) ->
            PlaceholderResult.value(
                ctx.player() != null
                    ? ctx.player().method_5476().getString()
                    : getConfig().i18n.serverName
            )
        );
        // minecord:world
        Placeholders.register(class_2960.method_60655("minecord", "world"), (ctx, arg) ->
            PlaceholderResult.value(ctx.world() != null ? StringUtils.getWorldName(ctx.world()) : "∞")
        );
    }
}
