/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.api.util;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.axieum.mcmod.minecord.api.Minecord;
import net.minecraft.class_2561;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholdersExt {
    public static final Pattern PLACEHOLDER_PATTERN = Placeholders.PREDEFINED_PLACEHOLDER_PATTERN;
    public static final NodeParser NODE_PARSER = NodeParser.merge((NodeParser[])new NodeParser[]{TextParserV1.DEFAULT, PatternPlaceholderParser.of((Pattern)PLACEHOLDER_PATTERN, (ParserContext.Key)PlaceholderContext.KEY, (Placeholders.PlaceholderGetter)Placeholders.DEFAULT_PLACEHOLDER_GETTER)});

    private PlaceholdersExt() {
    }

    @Nullable
    public static PlaceholderContext getMinecordServerContext() {
        return Minecord.getInstance().getMinecraft().map(PlaceholderContext::of).orElse(null);
    }

    public static class_2561 parseText(@NotNull TextNode node, @Nullable PlaceholderContext context, @NotNull Map<String, PlaceholderHandler> placeholders) {
        return PlaceholdersExt.parseText(node, context, placeholders::get);
    }

    public static class_2561 parseText(@NotNull TextNode node, @Nullable PlaceholderContext context, @NotNull Placeholders.PlaceholderGetter placeholderGetter) {
        return context != null ? Placeholders.parseText((TextNode)node, (PlaceholderContext)context, (Pattern)PLACEHOLDER_PATTERN, (Placeholders.PlaceholderGetter)placeholderGetter) : Placeholders.parseNodes((TextNode)node, (Pattern)PLACEHOLDER_PATTERN, (Placeholders.PlaceholderGetter)placeholderGetter).toText(ParserContext.of(), true);
    }

    @NotNull
    public static TextNode parseNode(@Nullable class_2561 text) {
        return text != null ? new ParentNode(NODE_PARSER.parseNodes(TextNode.convert((class_2561)text))) : EmptyNode.INSTANCE;
    }

    public static String parseString(@NotNull String string, @Nullable PlaceholderContext context, @NotNull Map<String, PlaceholderHandler> placeholders) {
        return PlaceholdersExt.parseString(string, context, placeholders::get);
    }

    public static String parseString(@NotNull String string, @Nullable PlaceholderContext context, @NotNull Placeholders.PlaceholderGetter placeholderGetter) {
        return PlaceholdersExt.parseString(PlaceholdersExt.parseNode(string), context, placeholderGetter);
    }

    public static String parseString(@NotNull TextNode node, @Nullable PlaceholderContext context, @NotNull Map<String, PlaceholderHandler> placeholders) {
        return PlaceholdersExt.parseString(node, context, placeholders::get);
    }

    public static String parseString(@NotNull TextNode node, @Nullable PlaceholderContext context, @NotNull Placeholders.PlaceholderGetter placeholderGetter) {
        return PlaceholdersExt.parseText(node, context, placeholderGetter).getString();
    }

    @NotNull
    public static TextNode parseNode(@Nullable String string) {
        return string != null && !string.isEmpty() ? NODE_PARSER.parseNode(string) : EmptyNode.INSTANCE;
    }

    public static PlaceholderHandler string(String string) {
        return (ctx, arg) -> PlaceholderResult.value((String)string);
    }

    public static PlaceholderHandler text(class_2561 text) {
        return (ctx, arg) -> PlaceholderResult.value((class_2561)text);
    }

    public static PlaceholderHandler markdown(String markdown) {
        class_2561 markdownText = MarkdownLiteParserV1.ALL.parseText(markdown, ParserContext.of());
        return (ctx, arg) -> PlaceholderResult.value((class_2561)markdownText);
    }

    public static PlaceholderHandler duration(Duration duration) {
        return (ctx, arg) -> PlaceholderResult.value((String)(arg != null ? DurationFormatUtils.formatDuration((long)duration.toMillis(), (String)arg) : DurationFormatUtils.formatDurationWords((long)duration.toMillis(), (boolean)true, (boolean)true)));
    }

    public static PlaceholderHandler duration(Supplier<Duration> duration) {
        return (ctx, arg) -> PlaceholdersExt.duration((Duration)duration.get()).onPlaceholderRequest(ctx, arg);
    }
}

