/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.api.util;

import java.text.DecimalFormat;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringTemplate {
    public static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private String prefix = "${";
    @NotNull
    private String suffix = "}";
    private final HashMap<String, @Nullable Object> variables = new HashMap();
    private final List<Function<String, String>> transforms = new ArrayList<Function<String, String>>();

    public StringTemplate setPrefix(@NotNull String prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringTemplate setSuffix(@NotNull String suffix) {
        this.suffix = suffix;
        return this;
    }

    public StringTemplate add(@NotNull String name, @Nullable Object value) {
        this.variables.put(name, value);
        return this;
    }

    public StringTemplate add(@NotNull String name, @Nullable Supplier<Object> supplier) {
        this.variables.put(name, supplier);
        return this;
    }

    @Nullable
    public Object get(@NotNull String name) {
        return this.variables.get(name);
    }

    public StringTemplate remove(@NotNull String name) {
        this.variables.remove(name);
        return this;
    }

    public StringTemplate transform(Function<String, String> transformer) {
        this.transforms.add(transformer);
        return this;
    }

    public HashMap<String, Object> getVariables() {
        return this.variables;
    }

    public List<Function<String, String>> getTransforms() {
        return this.transforms;
    }

    public String format(@Nullable String template) {
        if (template == null || template.isBlank()) {
            return template;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = Pattern.compile(Pattern.quote(this.prefix) + "(?<name>.+?)(?::(?!-)(?<format>.*?))?(?::-(?<default>.*?))?" + Pattern.quote(this.suffix)).matcher(template);
        while (matcher.find()) {
            String name = matcher.group("name");
            @Nullable String format = matcher.group("format");
            @Nullable String fallback = matcher.group("default");
            @Nullable Object value = this.variables.get(name);
            if (value instanceof Supplier) {
                try {
                    value = ((Supplier)value).get();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to evaluate lazy variable '{}': {}", (Object)name, (Object)e.getMessage());
                    value = null;
                }
            }
            if (value != null) {
                try {
                    if (format != null && !format.isBlank()) {
                        if (value instanceof String) {
                            matcher.appendReplacement(builder, Matcher.quoteReplacement(String.format(format, value)));
                            continue;
                        }
                        if (value instanceof Number) {
                            matcher.appendReplacement(builder, new DecimalFormat(format).format(value));
                            continue;
                        }
                        if (value instanceof Temporal) {
                            matcher.appendReplacement(builder, DateTimeFormatter.ofPattern(format).format((Temporal)value));
                            continue;
                        }
                        if (value instanceof Duration) {
                            matcher.appendReplacement(builder, DurationFormatUtils.formatDuration((long)((Duration)value).toMillis(), (String)format));
                            continue;
                        }
                        throw new IllegalArgumentException("Format provided for unsupported variable type!");
                    }
                    if (value instanceof Duration) {
                        matcher.appendReplacement(builder, DurationFormatUtils.formatDurationWords((long)((Duration)value).toMillis(), (boolean)true, (boolean)true));
                        continue;
                    }
                    matcher.appendReplacement(builder, Matcher.quoteReplacement(String.valueOf(value)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Could not replace variable '{}': {}", (Object)name, (Object)e.getMessage());
                }
                continue;
            }
            if (!this.variables.containsKey(name) && fallback == null) continue;
            matcher.appendReplacement(builder, fallback != null ? fallback : "");
        }
        String result2 = matcher.appendTail(builder).toString();
        for (Function<String, String> transformer : this.transforms) {
            result2 = transformer.apply(result2);
        }
        return result2;
    }
}

