/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.api.util;

import com.vdurmont.emoji.EmojiParser;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.util.StringTemplate;
import me.axieum.mcmod.minecord.impl.MinecordImpl;
import net.dv8tion.jda.api.entities.IMentionable;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public final class StringUtils {
    public static final HashMap<class_2960, String> WORLD_NAMES = new HashMap(3);
    public static StringTemplate discordMinecraftST = new StringTemplate().transform(EmojiParser::parseToAliases).transform(class_124::method_539);
    public static StringTemplate minecraftDiscordST;

    private StringUtils() {
    }

    public static String bytesToHuman(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String discordToMinecraft(String contents) {
        return discordMinecraftST.format(contents);
    }

    public static String minecraftToDiscord(String contents) {
        return minecraftDiscordST.format(contents);
    }

    public static String getWorldName(class_1937 world) {
        class_2960 identifier = world.method_27983().method_29177();
        return MinecordImpl.getConfig().i18n.worlds.getOrDefault(identifier.toString(), StringUtils.deriveWorldName(identifier));
    }

    public static String deriveWorldName(class_2960 identifier) {
        return WORLD_NAMES.computeIfAbsent(identifier, id -> {
            String path = id.method_12832().replace('_', ' ').replaceFirst("(?i)the\\s", "");
            char[] chars = path.toCharArray();
            boolean capitalizeNext = true;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == ' ') {
                    capitalizeNext = true;
                    continue;
                }
                if (!capitalizeNext) continue;
                chars[i] = Character.toTitleCase(chars[i]);
                capitalizeNext = false;
            }
            return new String(chars);
        });
    }

    static {
        Pattern breaks = Pattern.compile("(?s)\\n+");
        Pattern bold = Pattern.compile("(?<=\u00a7l)(.+?)(?=\\s?\u00a7r|$)");
        Pattern underline = Pattern.compile("(?<=\u00a7n)(.+?)(?=\\s?\u00a7r|$)");
        Pattern italics = Pattern.compile("(?<=\u00a7o)(.+?)(?=\\s?\u00a7r|$)");
        Pattern strike = Pattern.compile("(?<=\u00a7m)(.+?)(?=\\s?\u00a7r|$)");
        Pattern spoilers = Pattern.compile("(?<=\u00a7k)(.+?)(?=\\s?\u00a7r|$)");
        Pattern mention = Pattern.compile("@(\\w+?)#(\\d{4})");
        Pattern mention2 = Pattern.compile("@((?!everyone|here)\\w+)(?!#\\d{4})\\b");
        Pattern channel = Pattern.compile("#(\\S+)");
        Function<MatchResult, String> resolveMention = m -> Minecord.getInstance().getJDA().flatMap(jda -> Optional.ofNullable(jda.getUserByTag(m.group(1), m.group(2)))).map(IMentionable::getAsMention).orElse(m.group(0));
        Function<MatchResult, String> resolveMention2 = m -> Minecord.getInstance().getJDA().flatMap(jda -> jda.getGuilds().stream().flatMap(g -> g.getMembersByEffectiveName(m.group(1), true).stream()).findFirst()).map(IMentionable::getAsMention).orElse(m.group(0));
        Function<MatchResult, String> resolveChannel = m -> Minecord.getInstance().getJDA().flatMap(jda -> jda.getTextChannelsByName(m.group(1), true).stream().findFirst()).map(IMentionable::getAsMention).orElse(m.group(0));
        minecraftDiscordST = new StringTemplate().transform(s -> breaks.matcher((CharSequence)s).replaceAll(" ")).transform(s -> bold.matcher((CharSequence)s).replaceAll("**$1**")).transform(s -> underline.matcher((CharSequence)s).replaceAll("__$1__")).transform(s -> italics.matcher((CharSequence)s).replaceAll("_$1_")).transform(s -> strike.matcher((CharSequence)s).replaceAll("~~$1~~")).transform(s -> spoilers.matcher((CharSequence)s).replaceAll("||$1||")).transform(s -> mention.matcher((CharSequence)s).replaceAll(resolveMention)).transform(s -> mention2.matcher((CharSequence)s).replaceAll(resolveMention2)).transform(s -> channel.matcher((CharSequence)s).replaceAll(resolveChannel)).transform(s -> s.replace("@everyone", "@_everyone_")).transform(s -> s.replace("@here", "@_here_")).transform(class_124::method_539);
    }
}

