/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.addon.MinecordAddon;
import me.axieum.mcmod.minecord.api.event.JDAEvents;
import me.axieum.mcmod.minecord.api.event.ServerShutdownCallback;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.callback.DiscordLifecycleListener;
import me.axieum.mcmod.minecord.impl.callback.ServerLifecycleCallback;
import me.axieum.mcmod.minecord.impl.config.MinecordConfig;
import me.axieum.mcmod.minecord.impl.placeholder.MinecordPlaceholders;
import me.shedaniel.autoconfig.AutoConfig;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;

public final class MinecordImpl
implements Minecord,
PreLaunchEntrypoint,
DedicatedServerModInitializer {
    public static final Minecord INSTANCE = new MinecordImpl();
    public static final Logger LOGGER = LogManager.getLogger((String)"Minecord");
    @Nullable
    private static MinecraftServer minecraft = null;
    @Nullable
    private static JDA client = null;

    public void onPreLaunch() {
        LOGGER.info("Minecord is getting ready...");
        MinecordConfig.load();
        MinecordPlaceholders.register();
        try {
            JDABuilder builder = JDABuilder.createDefault(MinecordImpl.getConfig().bot.token).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).setStatus(MinecordImpl.getConfig().bot.status.starting).addEventListeners(new DiscordLifecycleListener());
            if (MinecordImpl.getConfig().bot.cacheMembers) {
                builder.enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[0]).setMemberCachePolicy(MemberCachePolicy.ALL).setChunkingFilter(ChunkingFilter.ALL);
            }
            FabricLoader.getInstance().invokeEntrypoints("minecord", MinecordAddon.class, addon -> addon.onInitializeMinecord(builder));
            ((JDAEvents.BuildClient)JDAEvents.BUILD_CLIENT.invoker()).onBuildClient(builder);
            LOGGER.info("Logging into Discord...");
            client = builder.build();
        }
        catch (IllegalArgumentException | InvalidTokenException e) {
            LOGGER.error("Unable to login to Discord: {}", (Object)e.getMessage());
        }
    }

    public void onInitializeServer() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            minecraft = server;
        });
        ServerLifecycleCallback lifecycleCallback = new ServerLifecycleCallback();
        ServerLifecycleEvents.SERVER_STARTING.register((Object)lifecycleCallback);
        ServerLifecycleEvents.SERVER_STARTED.register((Object)lifecycleCallback);
        ServerLifecycleEvents.SERVER_STOPPING.register((Object)lifecycleCallback);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ServerShutdownCallback.EVENT.register((Object)lifecycleCallback));
    }

    @Override
    public Optional<MinecraftServer> getMinecraft() {
        return Optional.ofNullable(minecraft);
    }

    @Override
    public Optional<JDA> getJDA() {
        return Optional.ofNullable(client);
    }

    @Override
    public Optional<String> getAvatarUrl(@Nullable String uuid, int height) {
        if (MinecordImpl.getConfig().misc.enableAvatars && uuid != null && !uuid.isBlank()) {
            return this.getMinecraft().map(server -> {
                class_3222 player;
                String skinId = null;
                if (FabricLoader.getInstance().isModLoaded("fabrictailor") && (player = server.method_3760().method_14602(UUID.fromString(uuid))) != null) {
                    skinId = ((TailoredPlayer)player).fabrictailor_getSkinId();
                }
                return PlaceholdersExt.parseString(MinecordImpl.getConfig().misc.avatarUrlNode, PlaceholderContext.of((MinecraftServer)server), Map.of("uuid", PlaceholdersExt.string(uuid), "skin_id", PlaceholdersExt.string(skinId != null ? skinId : uuid), "size", PlaceholdersExt.string(String.valueOf(height))));
            });
        }
        return Optional.empty();
    }

    public static MinecordConfig getConfig() {
        return (MinecordConfig)AutoConfig.getConfigHolder(MinecordConfig.class).getConfig();
    }
}

