/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.config;

import eu.pb4.placeholders.api.node.TextNode;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.dv8tion.jda.api.EmbedBuilder;

@Config(name="misc")
public class MiscConfig
implements ConfigData {
    @Comment(value="True if player avatars are included with embeds")
    public boolean enableAvatars = true;
    @Comment(value="The URL used for retrieving Minecraft player avatars\nUsages: ${uuid}, ${skin_id} and ${size} (height in pixels)")
    public String avatarUrl = "https://api.tydiumcraft.net/v1/players/skin?uuid=${skin_id}&type=avatar&size=${size}";
    public transient TextNode avatarUrlNode;

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.avatarUrl == null || this.avatarUrl.isBlank()) {
            throw new ConfigData.ValidationException("The avatar URL cannot be blank!");
        }
        if (this.avatarUrl.length() > 2000) {
            throw new ConfigData.ValidationException("The avatar URL cannot be longer than 2000 characters!");
        }
        if (!EmbedBuilder.URL_PATTERN.matcher(this.avatarUrl).matches()) {
            throw new ConfigData.ValidationException("The avatar URL must be a valid http(s) or attachment url!");
        }
        this.avatarUrlNode = PlaceholdersExt.parseNode(this.avatarUrl);
    }
}

