/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.replacer;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.internal.components.replacer.TypedComponentReplacerImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

@FunctionalInterface
public interface ComponentReplacer {
    @Nullable
    public Component apply(@Nonnull Component var1);

    @Nonnull
    public static ComponentReplacer all(@Nonnull Collection<? extends ComponentReplacer> replacers) {
        Checks.notEmpty(replacers, "ComponentReplacers");
        Checks.noneNull(replacers, "ComponentReplacers");
        return oldComponent -> {
            Iterator iterator2 = replacers.iterator();
            Component newComponent = oldComponent;
            do {
                newComponent = ((ComponentReplacer)iterator2.next()).apply(newComponent);
            } while (iterator2.hasNext() && newComponent != null);
            return newComponent;
        };
    }

    @Nonnull
    public static ComponentReplacer all(@Nonnull ComponentReplacer first, ComponentReplacer ... others) {
        Checks.notNull(first, "ComponentReplacer");
        Checks.noneNull(others, "ComponentReplacers");
        return ComponentReplacer.all(Helpers.mergeVararg(first, others));
    }

    @Nonnull
    public static <T extends Component> ComponentReplacer of(@Nonnull Class<? super T> type, @Nonnull Predicate<? super T> filter, @Nonnull Function<? super T, Component> update) {
        Checks.notNull(type, "Component type");
        Checks.notNull(filter, "Component filter");
        Checks.notNull(update, "Component updater");
        return new TypedComponentReplacerImpl<T>(type, filter, update);
    }

    @Nonnull
    public static ComponentReplacer byUniqueId(@Nonnull Component oldComponent, @Nullable Component newComponent) {
        return ComponentReplacer.byUniqueId(oldComponent.getUniqueId(), newComponent);
    }

    @Nonnull
    public static ComponentReplacer byUniqueId(int id, @Nullable Component newComponent) {
        return ComponentReplacer.of(Component.class, component -> component.getUniqueId() == id, component -> newComponent);
    }

    @Nonnull
    public static ComponentReplacer byUniqueId(int id, @Nonnull Function<? super Component, Component> update) {
        Checks.notNull(update, "Component updater");
        return ComponentReplacer.of(Component.class, component -> component.getUniqueId() == id, update);
    }
}

