/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CountingLongPredicate;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LongBiPredicate;
import org.apache.commons.collections4.bloomfilter.SetOperations;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class SimpleBloomFilter
implements BloomFilter<SimpleBloomFilter> {
    private final long[] bitMap;
    private final Shape shape;
    private int cardinality;

    public SimpleBloomFilter(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        this.shape = shape;
        this.bitMap = BitMaps.newBitMap(shape);
        this.cardinality = 0;
    }

    private SimpleBloomFilter(SimpleBloomFilter source2) {
        this.shape = source2.shape;
        this.bitMap = (long[])source2.bitMap.clone();
        this.cardinality = source2.cardinality;
    }

    @Override
    public long[] asBitMapArray() {
        return Arrays.copyOf(this.bitMap, this.bitMap.length);
    }

    @Override
    public int cardinality() {
        int c = this.cardinality;
        if (c < 0) {
            this.cardinality = c = SetOperations.cardinality(this);
        }
        return c;
    }

    @Override
    public int characteristics() {
        return 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.bitMap, 0L);
        this.cardinality = 0;
    }

    @Override
    public boolean contains(IndexExtractor indexExtractor) {
        return indexExtractor.processIndices(idx -> BitMaps.contains(this.bitMap, idx));
    }

    @Override
    public SimpleBloomFilter copy() {
        return new SimpleBloomFilter(this);
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0 || this.processBitMaps(y -> y == 0L);
    }

    @Override
    public boolean merge(BitMapExtractor bitMapExtractor) {
        Objects.requireNonNull(bitMapExtractor, "bitMapExtractor");
        try {
            long excess;
            int[] idx = new int[1];
            bitMapExtractor.processBitMaps(value -> {
                int n = idx[0];
                idx[0] = n + 1;
                this.bitMap[n] = this.bitMap[n] | value;
                return true;
            });
            idx[0] = idx[0] - 1;
            int idxLimit = BitMaps.getLongIndex(this.shape.getNumberOfBits());
            if (idxLimit == idx[0] && (excess = this.bitMap[idxLimit] >> this.shape.getNumberOfBits()) != 0L) {
                throw new IllegalArgumentException(String.format("BitMapExtractor set a bit higher than the limit for the shape: %s", this.shape.getNumberOfBits()));
            }
            this.cardinality = -1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("BitMapExtractor should send at most %s maps", this.bitMap.length), e);
        }
        return true;
    }

    @Override
    public boolean merge(BloomFilter<?> other) {
        Objects.requireNonNull(other, "other");
        if ((other.characteristics() & 1) != 0) {
            this.merge((IndexExtractor)other);
        } else {
            this.merge((BitMapExtractor)other);
        }
        return true;
    }

    @Override
    public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.shape));
    }

    @Override
    public boolean merge(IndexExtractor indexExtractor) {
        Objects.requireNonNull(indexExtractor, "indexExtractor");
        indexExtractor.processIndices(idx -> {
            if (idx < 0 || idx >= this.shape.getNumberOfBits()) {
                throw new IllegalArgumentException(String.format("IndexExtractor should only send values in the range[0,%s)", this.shape.getNumberOfBits()));
            }
            BitMaps.set(this.bitMap, idx);
            return true;
        });
        this.cardinality = -1;
        return true;
    }

    @Override
    public boolean processBitMapPairs(BitMapExtractor other, LongBiPredicate func) {
        CountingLongPredicate p = new CountingLongPredicate(this.bitMap, func);
        return other.processBitMaps(p) && p.processRemaining();
    }

    @Override
    public boolean processBitMaps(LongPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        for (long l : this.bitMap) {
            if (consumer.test(l)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processIndices(IntPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return IndexExtractor.fromBitMapExtractor(this).processIndices(consumer);
    }
}

