/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class MultiKey<K>
implements Serializable {
    private static final long serialVersionUID = 4465448607415788805L;
    private final K[] keys;
    private transient int hashCode;

    private static <T> Class<? extends T> getClass(T value) {
        return value == null ? Object.class : value.getClass();
    }

    @SafeVarargs
    private static <T> Class<? extends T> getComponentType(T ... values2) {
        Class<Object> rootClass = Object.class;
        if (values2 == null) {
            return rootClass;
        }
        Class prevClass = values2.length > 0 ? MultiKey.getClass(values2[0]) : rootClass;
        for (int i = 1; i < values2.length; ++i) {
            Class<T> classI = MultiKey.getClass(values2[i]);
            if (prevClass != classI) {
                return rootClass;
            }
            prevClass = classI;
        }
        return prevClass;
    }

    private static <T> T[] newArray(T key1, T key2) {
        Object[] array = (Object[])Array.newInstance(MultiKey.getComponentType(key1, key2), 2);
        array[0] = key1;
        array[1] = key2;
        return array;
    }

    private static <T> T[] newArray(T key1, T key2, T key3) {
        Object[] array = (Object[])Array.newInstance(MultiKey.getComponentType(key1, key2, key3), 3);
        array[0] = key1;
        array[1] = key2;
        array[2] = key3;
        return array;
    }

    private static <T> T[] newArray(T key1, T key2, T key3, T key4) {
        Object[] array = (Object[])Array.newInstance(MultiKey.getComponentType(key1, key2, key3, key4), 4);
        array[0] = key1;
        array[1] = key2;
        array[2] = key3;
        array[3] = key4;
        return array;
    }

    private static <T> T[] newArray(T key1, T key2, T key3, T key4, T key5) {
        Object[] array = (Object[])Array.newInstance(MultiKey.getComponentType(key1, key2, key3, key4, key5), 5);
        array[0] = key1;
        array[1] = key2;
        array[2] = key3;
        array[3] = key4;
        array[4] = key5;
        return array;
    }

    public MultiKey(K key1, K key2) {
        this(MultiKey.newArray(key1, key2), false);
    }

    public MultiKey(K key1, K key2, K key3) {
        this(MultiKey.newArray(key1, key2, key3), false);
    }

    public MultiKey(K key1, K key2, K key3, K key4) {
        this(MultiKey.newArray(key1, key2, key3, key4), false);
    }

    public MultiKey(K key1, K key2, K key3, K key4, K key5) {
        this(MultiKey.newArray(key1, key2, key3, key4, key5), false);
    }

    public MultiKey(K[] keys2) {
        this(keys2, true);
    }

    public MultiKey(K[] keys2, boolean makeClone) {
        Objects.requireNonNull(keys2, "keys");
        this.keys = makeClone ? (Object[])keys2.clone() : keys2;
        this.calculateHashCode(keys2);
    }

    private void calculateHashCode(Object[] keys2) {
        int total = 0;
        for (Object key : keys2) {
            if (key == null) continue;
            total ^= key.hashCode();
        }
        this.hashCode = total;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey otherMulti = (MultiKey)other;
            return Arrays.equals(this.keys, otherMulti.keys);
        }
        return false;
    }

    public K getKey(int index) {
        return this.keys[index];
    }

    public K[] getKeys() {
        return (Object[])this.keys.clone();
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected Object readResolve() {
        this.calculateHashCode(this.keys);
        return this;
    }

    public int size() {
        return this.keys.length;
    }

    public String toString() {
        return "MultiKey" + Arrays.toString(this.keys);
    }
}

