/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.api.chat.event;

import com.github.difflib.text.DiffRow;
import java.util.List;
import me.axieum.mcmod.minecord.api.util.StringTemplate;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ChatPlaceholderEvents {
    private ChatPlaceholderEvents() {
    }

    public static final class Minecraft {
        public static final Event<ServerStarting> SERVER_STARTING = EventFactory.createArrayBacked(ServerStarting.class, callbacks -> (st, server) -> {
            for (ServerStarting callback : callbacks) {
                callback.onServerStartingPlaceholder(st, server);
            }
        });
        public static final Event<ServerStarted> SERVER_STARTED = EventFactory.createArrayBacked(ServerStarted.class, callbacks -> (st, server) -> {
            for (ServerStarted callback : callbacks) {
                callback.onServerStartedPlaceholder(st, server);
            }
        });
        public static final Event<ServerStopping> SERVER_STOPPING = EventFactory.createArrayBacked(ServerStopping.class, callbacks -> (st, server) -> {
            for (ServerStopping callback : callbacks) {
                callback.onServerStoppingPlaceholder(st, server);
            }
        });
        public static final Event<ServerShutdown> SERVER_SHUTDOWN = EventFactory.createArrayBacked(ServerShutdown.class, callbacks -> (st, server, crashReport) -> {
            for (ServerShutdown callback : callbacks) {
                callback.onServerShutdownPlaceholder(st, server, crashReport);
            }
        });
        public static final Event<EntityDeath> ENTITY_DEATH = EventFactory.createArrayBacked(EntityDeath.class, callbacks -> (st, entity, source) -> {
            for (EntityDeath callback : callbacks) {
                callback.onEntityDeathPlaceholder(st, entity, source);
            }
        });
        public static final Event<PlayerConnect> PLAYER_CONNECT = EventFactory.createArrayBacked(PlayerConnect.class, callbacks -> (st, player) -> {
            for (PlayerConnect callback : callbacks) {
                callback.onPlayerConnectPlaceholder(st, player);
            }
        });
        public static final Event<PlayerDisconnect> PLAYER_DISCONNECT = EventFactory.createArrayBacked(PlayerDisconnect.class, callbacks -> (st, player) -> {
            for (PlayerDisconnect callback : callbacks) {
                callback.onPlayerDisconnectPlaceholder(st, player);
            }
        });
        public static final Event<PlayerChat> PLAYER_CHAT = EventFactory.createArrayBacked(PlayerChat.class, callbacks -> (st, player, message, typeKey) -> {
            for (PlayerChat callback : callbacks) {
                callback.onPlayerChatPlaceholder(st, player, message, typeKey);
            }
        });
        public static final Event<PlayerAdvancement> PLAYER_ADVANCEMENT = EventFactory.createArrayBacked(PlayerAdvancement.class, callbacks -> (st, player, adv, criterion) -> {
            for (PlayerAdvancement callback : callbacks) {
                callback.onPlayerAdvancementPlaceholder(st, player, adv, criterion);
            }
        });
        public static final Event<PlayerChangeWorld> PLAYER_CHANGE_WORLD = EventFactory.createArrayBacked(PlayerChangeWorld.class, callbacks -> (st, player, origin, destination) -> {
            for (PlayerChangeWorld callback : callbacks) {
                callback.onPlayerChangeWorldPlaceholder(st, player, origin, destination);
            }
        });
        public static final Event<PlayerDeath> PLAYER_DEATH = EventFactory.createArrayBacked(PlayerDeath.class, callbacks -> (st, player, source) -> {
            for (PlayerDeath callback : callbacks) {
                callback.onPlayerDeathPlaceholder(st, player, source);
            }
        });
        public static final Event<EmoteCommand> EMOTE_COMMAND = EventFactory.createArrayBacked(EmoteCommand.class, callbacks -> (st, source, action, params) -> {
            for (EmoteCommand callback : callbacks) {
                callback.onEmoteCommandPlaceholder(st, source, action, params);
            }
        });
        public static final Event<SayCommand> SAY_COMMAND = EventFactory.createArrayBacked(SayCommand.class, callbacks -> (st, source, action, params) -> {
            for (SayCommand callback : callbacks) {
                callback.onSayCommandPlaceholder(st, source, action, params);
            }
        });
        public static final Event<TellRawCommand> TELLRAW_COMMAND = EventFactory.createArrayBacked(TellRawCommand.class, callbacks -> (st, source, action) -> {
            for (TellRawCommand callback : callbacks) {
                callback.onTellRawCommandPlaceholder(st, source, action);
            }
        });

        @FunctionalInterface
        public static interface TellRawCommand {
            public void onTellRawCommandPlaceholder(StringTemplate var1, class_2168 var2, class_2561 var3);
        }

        @FunctionalInterface
        public static interface SayCommand {
            public void onSayCommandPlaceholder(StringTemplate var1, class_2168 var2, class_7471 var3, class_2556.class_7602 var4);
        }

        @FunctionalInterface
        public static interface EmoteCommand {
            public void onEmoteCommandPlaceholder(StringTemplate var1, class_2168 var2, class_7471 var3, class_2556.class_7602 var4);
        }

        @FunctionalInterface
        public static interface PlayerDeath {
            public void onPlayerDeathPlaceholder(StringTemplate var1, class_3222 var2, class_1282 var3);
        }

        @FunctionalInterface
        public static interface PlayerChangeWorld {
            public void onPlayerChangeWorldPlaceholder(StringTemplate var1, class_3222 var2, class_3218 var3, class_3218 var4);
        }

        @FunctionalInterface
        public static interface PlayerAdvancement {
            public void onPlayerAdvancementPlaceholder(StringTemplate var1, class_3222 var2, class_161 var3, String var4);
        }

        @FunctionalInterface
        public static interface PlayerChat {
            public void onPlayerChatPlaceholder(StringTemplate var1, class_3222 var2, class_7471 var3, class_2556.class_7602 var4);
        }

        @FunctionalInterface
        public static interface PlayerDisconnect {
            public void onPlayerDisconnectPlaceholder(StringTemplate var1, class_3222 var2);
        }

        @FunctionalInterface
        public static interface PlayerConnect {
            public void onPlayerConnectPlaceholder(StringTemplate var1, class_3222 var2);
        }

        @FunctionalInterface
        public static interface EntityDeath {
            public void onEntityDeathPlaceholder(StringTemplate var1, class_1309 var2, class_1282 var3);
        }

        @FunctionalInterface
        public static interface ServerShutdown {
            public void onServerShutdownPlaceholder(StringTemplate var1, MinecraftServer var2, @Nullable class_128 var3);
        }

        @FunctionalInterface
        public static interface ServerStopping {
            public void onServerStoppingPlaceholder(StringTemplate var1, MinecraftServer var2);
        }

        @FunctionalInterface
        public static interface ServerStarted {
            public void onServerStartedPlaceholder(StringTemplate var1, MinecraftServer var2);
        }

        @FunctionalInterface
        public static interface ServerStarting {
            public void onServerStartingPlaceholder(StringTemplate var1, MinecraftServer var2);
        }
    }

    public static final class Discord {
        public static final Event<MessageReceived> MESSAGE_RECEIVED = EventFactory.createArrayBacked(MessageReceived.class, callbacks -> (st, event) -> {
            for (MessageReceived callback : callbacks) {
                callback.onMessageReceivedPlaceholder(st, event);
            }
        });
        public static final Event<ReplyReceived> REPLY_RECEIVED = EventFactory.createArrayBacked(ReplyReceived.class, callbacks -> (st, event) -> {
            for (ReplyReceived callback : callbacks) {
                callback.onReplyReceivedPlaceholder(st, event);
            }
        });
        public static final Event<MessageUpdated> MESSAGE_UPDATED = EventFactory.createArrayBacked(MessageUpdated.class, callbacks -> (st, event, context, diff) -> {
            for (MessageUpdated callback : callbacks) {
                callback.onMessageUpdatedPlaceholder(st, event, context, diff);
            }
        });
        public static final Event<AttachmentReceived> ATTACHMENT_RECEIVED = EventFactory.createArrayBacked(AttachmentReceived.class, callbacks -> (st, event, attachment) -> {
            for (AttachmentReceived callback : callbacks) {
                callback.onAttachmentReceivedPlaceholder(st, event, attachment);
            }
        });
        public static final Event<ReactionAdded> REACTION = EventFactory.createArrayBacked(ReactionAdded.class, callbacks -> (st, event) -> {
            for (ReactionAdded callback : callbacks) {
                callback.onReactionPlaceholder(st, event);
            }
        });

        @FunctionalInterface
        public static interface ReactionAdded {
            public void onReactionPlaceholder(StringTemplate var1, GenericMessageReactionEvent var2);
        }

        @FunctionalInterface
        public static interface AttachmentReceived {
            public void onAttachmentReceivedPlaceholder(StringTemplate var1, MessageReceivedEvent var2, Message.Attachment var3);
        }

        @FunctionalInterface
        public static interface MessageUpdated {
            public void onMessageUpdatedPlaceholder(StringTemplate var1, MessageUpdateEvent var2, Message var3, List<DiffRow> var4);
        }

        @FunctionalInterface
        public static interface ReplyReceived {
            public void onReplyReceivedPlaceholder(StringTemplate var1, MessageReceivedEvent var2);
        }

        @FunctionalInterface
        public static interface MessageReceived {
            public void onMessageReceivedPlaceholder(StringTemplate var1, MessageReceivedEvent var2);
        }
    }
}

