/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.callback.discord;

import com.vdurmont.emoji.EmojiParser;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Map;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.chat.MinecordChat;
import me.axieum.mcmod.minecord.impl.chat.util.MinecraftDispatcher;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.Nullable;

public class MessageReactionListener
extends ListenerAdapter {
    public void onGenericMessageReaction(GenericMessageReactionEvent event) {
        if (event.getMember() == null) {
            return;
        }
        long channelId = event.getChannel().getIdLong();
        if (!MinecordChat.getConfig().hasChannel(channelId)) {
            return;
        }
        event.retrieveMessage().queue(context -> {
            boolean isAdded = event instanceof MessageReactionAddEvent;
            String emote = EmojiParser.parseToAliases((String)event.getEmoji().getName());
            @Nullable PlaceholderContext ctx = PlaceholdersExt.getMinecordServerContext();
            Map<String, PlaceholderHandler> placeholders = Map.of("issuer_tag", PlaceholdersExt.string((String)event.getUser().getName()), "issuer_username", PlaceholdersExt.string((String)event.getUser().getName()), "issuer_discriminator", PlaceholdersExt.string((String)event.getUser().getDiscriminator()), "issuer", PlaceholdersExt.string((String)(event.getMember() != null ? event.getMember().getEffectiveName() : event.getUser().getName())), "author_tag", PlaceholdersExt.string((String)context.getAuthor().getName()), "author_username", PlaceholdersExt.string((String)context.getAuthor().getName()), "author_discriminator", PlaceholdersExt.string((String)context.getAuthor().getDiscriminator()), "author", PlaceholdersExt.string((String)(context.getMember() != null ? context.getMember().getEffectiveName() : context.getAuthor().getName())), "emote", PlaceholdersExt.string((String)emote));
            if (isAdded) {
                MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.reactNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.react != null && entry.id == channelId);
                MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${issuer_tag} reacted with ${emote} to ${author_tag}'s message", (PlaceholderContext)ctx, placeholders));
            } else {
                MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.unreactNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.unreact != null && entry.id == channelId);
                MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${issuer_tag} removed their reaction of ${emote} from ${author_tag}'s message", (PlaceholderContext)ctx, placeholders));
            }
        });
    }
}

