/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.callback.discord;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.HashMap;
import java.util.Map;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.api.util.StringUtils;
import me.axieum.mcmod.minecord.impl.chat.MinecordChat;
import me.axieum.mcmod.minecord.impl.chat.util.MinecraftDispatcher;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.sticker.StickerItem;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.Nullable;

public class MessageReceivedListener
extends ListenerAdapter {
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        if (!MinecordChat.getConfig().hasChannel(event.getChannel().getIdLong())) {
            return;
        }
        if (!event.getMessage().getContentRaw().isEmpty()) {
            this.onText(event);
        }
        event.getMessage().getStickers().forEach(sticker -> this.onSticker(event, (StickerItem)sticker));
        event.getMessage().getAttachments().forEach(attachment -> this.onAttachment(event, (Message.Attachment)attachment));
    }

    public void onText(MessageReceivedEvent event) {
        long channelId = event.getChannel().getIdLong();
        @Nullable Message replyMessage = event.getMessage().getReferencedMessage();
        @Nullable PlaceholderContext ctx = PlaceholdersExt.getMinecordServerContext();
        HashMap<String, PlaceholderHandler> placeholders = new HashMap<String, PlaceholderHandler>(Map.of("tag", PlaceholdersExt.string((String)event.getAuthor().getName()), "username", PlaceholdersExt.string((String)event.getAuthor().getName()), "discriminator", PlaceholdersExt.string((String)event.getAuthor().getDiscriminator()), "author", PlaceholdersExt.string((String)(event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName())), "message", PlaceholdersExt.markdown((String)StringUtils.discordToMinecraft((String)event.getMessage().getContentDisplay())), "raw", PlaceholdersExt.string((String)event.getMessage().getContentRaw())));
        if (replyMessage != null) {
            placeholders.putAll(Map.of("reply_tag", PlaceholdersExt.string((String)replyMessage.getAuthor().getName()), "reply_username", PlaceholdersExt.string((String)replyMessage.getAuthor().getName()), "reply_discriminator", PlaceholdersExt.string((String)replyMessage.getAuthor().getDiscriminator()), "reply_author", PlaceholdersExt.string((String)(replyMessage.getMember() != null ? replyMessage.getMember().getEffectiveName() : replyMessage.getAuthor().getName())), "reply_message", PlaceholdersExt.markdown((String)StringUtils.discordToMinecraft((String)replyMessage.getContentDisplay())), "reply_raw", PlaceholdersExt.string((String)replyMessage.getContentRaw())));
        }
        if (replyMessage == null) {
            MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.chatNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.chat != null && entry.id == channelId);
            MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${tag} > ${message}", (PlaceholderContext)ctx, placeholders));
        } else {
            MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.replyNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.reply != null && entry.id == channelId);
            MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${tag} (in reply to @${reply_tag}) > ${message}", (PlaceholderContext)ctx, placeholders));
        }
    }

    public void onSticker(MessageReceivedEvent event, StickerItem sticker) {
        long channelId = event.getChannel().getIdLong();
        @Nullable PlaceholderContext ctx = PlaceholdersExt.getMinecordServerContext();
        Map<String, PlaceholderHandler> placeholders = Map.of("tag", PlaceholdersExt.string((String)event.getAuthor().getName()), "username", PlaceholdersExt.string((String)event.getAuthor().getName()), "discriminator", PlaceholdersExt.string((String)event.getAuthor().getDiscriminator()), "author", PlaceholdersExt.string((String)(event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName())), "url", PlaceholdersExt.string((String)sticker.getIconUrl()), "name", PlaceholdersExt.string((String)sticker.getName()));
        MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.stickerNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.sticker != null && entry.id == channelId);
        MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${tag} sent sticker ${name}", (PlaceholderContext)ctx, placeholders));
    }

    public void onAttachment(MessageReceivedEvent event, Message.Attachment attachment) {
        long channelId = event.getChannel().getIdLong();
        @Nullable PlaceholderContext ctx = PlaceholdersExt.getMinecordServerContext();
        Map<String, PlaceholderHandler> placeholders = Map.of("tag", PlaceholdersExt.string((String)event.getAuthor().getName()), "username", PlaceholdersExt.string((String)event.getAuthor().getName()), "discriminator", PlaceholdersExt.string((String)event.getAuthor().getDiscriminator()), "author", PlaceholdersExt.string((String)(event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName())), "url", PlaceholdersExt.string((String)attachment.getUrl()), "name", PlaceholdersExt.string((String)attachment.getFileName()), "ext", PlaceholdersExt.string((String)attachment.getFileExtension()), "size", PlaceholdersExt.string((String)StringUtils.bytesToHuman((long)attachment.getSize())));
        MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.attachmentNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.attachment != null && entry.id == channelId);
        MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${tag} attached ${name} (${size})", (PlaceholderContext)ctx, placeholders));
    }
}

