/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.callback.discord;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.api.util.StringUtils;
import me.axieum.mcmod.minecord.impl.chat.MinecordChat;
import me.axieum.mcmod.minecord.impl.chat.util.MinecraftDispatcher;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.minecraft.class_124;
import org.jetbrains.annotations.Nullable;

public class MessageUpdateListener
extends ListenerAdapter {
    private static final CircularLinkedHashMap<String, Message> MESSAGE_CACHE = new CircularLinkedHashMap(32);
    private static final DiffRowGenerator DIFF_GENERATOR = DiffRowGenerator.create().showInlineDiffs(true).mergeOriginalRevised(true).inlineDiffByWord(true).oldTag(f -> f != false ? String.valueOf(class_124.field_1061) + "~~" : "~~" + String.valueOf(class_124.field_1070)).newTag(f -> (f != false ? class_124.field_1060 : class_124.field_1070).toString()).build();

    public void onMessageUpdate(MessageUpdateEvent event) {
        MESSAGE_CACHE.computeIfPresent(event.getMessageId(), (id, context) -> {
            String original = StringUtils.discordToMinecraft((String)context.getContentDisplay());
            String message = StringUtils.discordToMinecraft((String)event.getMessage().getContentDisplay());
            List<DiffRow> diffs = DIFF_GENERATOR.generateDiffRows(Collections.singletonList(original), Collections.singletonList(message));
            if (!diffs.isEmpty()) {
                long channelId = event.getChannel().getIdLong();
                @Nullable PlaceholderContext ctx = PlaceholdersExt.getMinecordServerContext();
                Map<String, PlaceholderHandler> placeholders = Map.of("tag", PlaceholdersExt.string((String)event.getAuthor().getName()), "username", PlaceholdersExt.string((String)event.getAuthor().getName()), "discriminator", PlaceholdersExt.string((String)event.getAuthor().getDiscriminator()), "author", PlaceholdersExt.string((String)(event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName())), "original", PlaceholdersExt.markdown((String)original), "original_raw", PlaceholdersExt.string((String)context.getContentRaw()), "message", PlaceholdersExt.markdown((String)message), "raw", PlaceholdersExt.string((String)event.getMessage().getContentRaw()), "diff", PlaceholdersExt.markdown((String)diffs.get(0).getOldLine()));
                MinecraftDispatcher.dispatch(entry -> PlaceholdersExt.parseText((TextNode)entry.minecraft.editNode, (PlaceholderContext)ctx, (Map)placeholders), entry -> entry.minecraft.edit != null && entry.id == channelId);
                MinecordChat.LOGGER.info(PlaceholdersExt.parseString((String)"@${tag} > ${message}", (PlaceholderContext)ctx, placeholders));
            }
            return event.getMessage();
        });
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        if (!event.getAuthor().isBot() && MinecordChat.getConfig().hasChannel(event.getChannel().getIdLong())) {
            MESSAGE_CACHE.put(event.getMessageId(), event.getMessage());
        }
    }

    public void onMessageDelete(MessageDeleteEvent event) {
        MESSAGE_CACHE.remove(event.getMessageId());
    }

    private static final class CircularLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        private CircularLinkedHashMap(int capacity) {
            super(capacity, 1.0f);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }
}

