/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.callback.minecraft;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.node.TextNode;
import java.awt.Color;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.event.ServerShutdownCallback;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.chat.util.DiscordDispatcher;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_128;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerLifecycleCallback
implements ServerLifecycleEvents.ServerStarting,
ServerLifecycleEvents.ServerStarted,
ServerLifecycleEvents.ServerStopping,
ServerShutdownCallback {
    public void onServerStarting(MinecraftServer server) {
        Minecord.getInstance().getJDA().ifPresent(jda -> {
            PlaceholderContext ctx = PlaceholderContext.of((MinecraftServer)server);
            Map placeholders = Collections.emptyMap();
            DiscordDispatcher.embed((embed, entry) -> embed.setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)entry.discord.startingNode, (PlaceholderContext)ctx, (Map)placeholders)), entry -> entry.discord.starting != null);
        });
    }

    public void onServerStarted(MinecraftServer server) {
        Minecord.getInstance().getJDA().ifPresent(jda -> {
            PlaceholderContext ctx = PlaceholderContext.of((MinecraftServer)server);
            Map<String, PlaceholderHandler> placeholders = Map.of("uptime", PlaceholdersExt.duration((Duration)Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime())));
            DiscordDispatcher.embed((embed, entry) -> embed.setColor(Color.GREEN).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)entry.discord.startedNode, (PlaceholderContext)ctx, (Map)placeholders)), entry -> entry.discord.started != null);
        });
    }

    public void onServerStopping(MinecraftServer server) {
        Minecord.getInstance().getJDA().ifPresent(jda -> {
            PlaceholderContext ctx = PlaceholderContext.of((MinecraftServer)server);
            Map<String, PlaceholderHandler> placeholders = Map.of("uptime", PlaceholdersExt.duration((Duration)Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime())));
            DiscordDispatcher.embed((embed, entry) -> embed.setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)entry.discord.stoppingNode, (PlaceholderContext)ctx, (Map)placeholders)), entry -> entry.discord.stopping != null);
        });
    }

    public void onServerShutdown(MinecraftServer server, @Nullable class_128 crashReport) {
        Minecord.getInstance().getJDA().ifPresent(jda -> {
            PlaceholderContext ctx = PlaceholderContext.of((MinecraftServer)server);
            HashMap<String, PlaceholderHandler> placeholders = new HashMap<String, PlaceholderHandler>(Map.of("uptime", PlaceholdersExt.duration((Duration)Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime()))));
            if (crashReport != null) {
                placeholders.put("reason", PlaceholdersExt.string((String)crashReport.method_561()));
            }
            if (crashReport == null) {
                DiscordDispatcher.embed((embed, entry) -> embed.setColor(Color.RED).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)entry.discord.stoppedNode, (PlaceholderContext)ctx, (Map)placeholders)), entry -> entry.discord.stopped != null);
            } else {
                Optional<File> file = Optional.ofNullable(crashReport.method_572()).map(Path::toFile).filter(File::exists);
                DiscordDispatcher.embed((embed, entry) -> embed.setColor(Color.ORANGE).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)entry.discord.crashedNode, (PlaceholderContext)ctx, (Map)placeholders)), (action, entry) -> {
                    if (entry.discord.uploadCrashReport) {
                        file.map(FileUpload::fromData).ifPresent(xva$0 -> {
                            MessageCreateAction cfr_ignored_0 = (MessageCreateAction)action.addFiles(new FileUpload[]{xva$0});
                        });
                    }
                    action.queue();
                }, entry -> entry.discord.crashed != null);
            }
        });
    }
}

