/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.config;

import eu.pb4.placeholders.api.node.TextNode;
import java.util.Arrays;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1937;

@Config(name="minecord/chat")
public class ChatConfig
implements ConfigData {
    @Comment(value="Chat Configurations")
    public ChatEntrySchema[] entries = new ChatEntrySchema[]{new ChatEntrySchema()};

    public boolean hasChannel(long identifier) {
        return Arrays.stream(this.entries).anyMatch(entry -> entry.id == identifier);
    }

    public void validatePostLoad() {
        this.parseDiscordTemplates();
        if (Minecord.getInstance().getMinecraft().isPresent()) {
            this.parseMinecraftTemplates();
        }
    }

    public void parseDiscordTemplates() {
        Arrays.stream(this.entries).forEach(entry -> {
            entry.discord.chatNode = PlaceholdersExt.parseNode((String)entry.discord.chat);
            entry.discord.emoteNode = PlaceholdersExt.parseNode((String)entry.discord.emote);
            entry.discord.sayNode = PlaceholdersExt.parseNode((String)entry.discord.say);
            entry.discord.tellrawNode = PlaceholdersExt.parseNode((String)entry.discord.tellraw);
            entry.discord.deathNode = PlaceholdersExt.parseNode((String)entry.discord.death);
            entry.discord.griefNode = PlaceholdersExt.parseNode((String)entry.discord.grief);
            entry.discord.advancementTaskNode = PlaceholdersExt.parseNode((String)entry.discord.advancementTask);
            entry.discord.advancementGoalNode = PlaceholdersExt.parseNode((String)entry.discord.advancementGoal);
            entry.discord.advancementChallengeNode = PlaceholdersExt.parseNode((String)entry.discord.advancementChallenge);
            entry.discord.teleportNode = PlaceholdersExt.parseNode((String)entry.discord.teleport);
            entry.discord.joinNode = PlaceholdersExt.parseNode((String)entry.discord.join);
            entry.discord.leaveNode = PlaceholdersExt.parseNode((String)entry.discord.leave);
            entry.discord.startingNode = PlaceholdersExt.parseNode((String)entry.discord.starting);
            entry.discord.startedNode = PlaceholdersExt.parseNode((String)entry.discord.started);
            entry.discord.stoppingNode = PlaceholdersExt.parseNode((String)entry.discord.stopping);
            entry.discord.stoppedNode = PlaceholdersExt.parseNode((String)entry.discord.stopped);
            entry.discord.crashedNode = PlaceholdersExt.parseNode((String)entry.discord.crashed);
        });
    }

    public void parseMinecraftTemplates() {
        Arrays.stream(this.entries).forEach(entry -> {
            entry.minecraft.chatNode = PlaceholdersExt.parseNode((String)entry.minecraft.chat);
            entry.minecraft.replyNode = PlaceholdersExt.parseNode((String)entry.minecraft.reply);
            entry.minecraft.editNode = PlaceholdersExt.parseNode((String)entry.minecraft.edit);
            entry.minecraft.reactNode = PlaceholdersExt.parseNode((String)entry.minecraft.react);
            entry.minecraft.unreactNode = PlaceholdersExt.parseNode((String)entry.minecraft.unreact);
            entry.minecraft.stickerNode = PlaceholdersExt.parseNode((String)entry.minecraft.sticker);
            entry.minecraft.attachmentNode = PlaceholdersExt.parseNode((String)entry.minecraft.attachment);
        });
    }

    public static void load() {
        AutoConfig.register(ChatConfig.class, JanksonConfigSerializer::new);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(ChatConfig.class).load());
    }

    public static class ChatEntrySchema {
        @Comment(value="A channel identifier in Discord to observe")
        public long id;
        @Comment(value="If non-empty, reduces the scope of all events to the listed Minecraft dimension IDs, e.g. 'minecraft:the_nether'")
        public String[] dimensions = new String[0];
        @ConfigEntry.Category(value="Discord")
        @Comment(value="Minecraft events relayed to Discord")
        public DiscordSchema discord = new DiscordSchema();
        @ConfigEntry.Category(value="Minecraft")
        @Comment(value="Discord events relayed to Minecraft")
        public MinecraftSchema minecraft = new MinecraftSchema();

        public boolean hasWorld(class_1937 world) {
            return world == null || this.dimensions == null || this.dimensions.length == 0 || Arrays.asList(this.dimensions).contains(world.method_27983().method_29177().toString());
        }

        public static class DiscordSchema {
            @Comment(value="A player sent an in-game chat message\nUsages: ${message}")
            public String chat = "`${minecord:world}` **${minecord:player}** > ${message}";
            public transient TextNode chatNode;
            @Comment(value="True if links are purged from player messages before being forwarded to Discord")
            public boolean purgeLinks = false;
            @Comment(value="A player sent an in-game message via the '/me' command\nUsages: ${action}")
            public String emote = "`${minecord:world}` **${minecord:player}** _${action}_";
            public transient TextNode emoteNode;
            @Comment(value="An admin broadcast an in-game message via the '/say' command\nUsages: ${message}")
            public String say = "**[${minecord:player}]** ${message}";
            public transient TextNode sayNode;
            @Comment(value="An admin broadcast an in-game message to all players via the '/tellraw @a' command\nUsages: ${message}")
            public String tellraw = "${message}";
            public transient TextNode tellrawNode;
            @Comment(value="A player had died\nUsages: ${cause}, ${exp}, ${lifespan [format]} and ${score}")
            public String death = "**${minecord:player}** ${cause}! :skull:\n_${minecord:world} at ${player:pos_x 0}, ${player:pos_y 0}, ${player:pos_z 0}_";
            public transient TextNode deathNode;
            @Comment(value="A named animal/monster (with name tag) had died\nUsages: ${name}, ${cause}, ${pos_x}, ${pos_y} and ${pos_z}")
            public String grief = "**${name}** ${cause}! :coffin:\n_${minecord:world} at ${pos_x}, ${pos_y}, ${pos_z}_";
            public transient TextNode griefNode;
            @Comment(value="A player unlocked an advancement task\nUsages: ${title} and ${description}")
            public String advancementTask = "**${minecord:player}** has made the advancement **${title}**! :clap:\n_${description}_";
            public transient TextNode advancementTaskNode;
            @Comment(value="A player reached an advancement goal\nUsages: ${title} and ${description}")
            public String advancementGoal = "**${minecord:player}** has reached the goal **${title}**! :clap:\n_${description}_";
            public transient TextNode advancementGoalNode;
            @Comment(value="A player completed an advancement challenge\nUsages: ${title} and ${description}")
            public String advancementChallenge = "**${minecord:player}** has completed the challenge **${title}**! :trophy:\n_${description}_";
            public transient TextNode advancementChallengeNode;
            @Comment(value="A player teleported to another dimension\nUsages: ${world}, ${pos_x}, ${pos_y}, ${pos_z}, ${origin}, ${origin_pos_x}, ${origin_pos_y} and ${origin_pos_z}")
            public String teleport = "**${minecord:player}** entered ${world}. :cyclone:";
            public transient TextNode teleportNode;
            @Comment(value="A player joined the game")
            public String join = "**${minecord:player}** joined!";
            public transient TextNode joinNode;
            @Comment(value="A player left the game")
            public String leave = "**${minecord:player}** left!";
            public transient TextNode leaveNode;
            @Comment(value="The server began to start")
            public String starting = "Server is starting... :fingers_crossed:";
            public transient TextNode startingNode;
            @Comment(value="The server started and is accepting connections\nUsages: ${uptime [format]}")
            public String started = "Server started (took ${uptime s.SSS}s) :ok_hand:";
            public transient TextNode startedNode;
            @Comment(value="The server began to stop\nUsages: ${uptime [format]}")
            public String stopping = "Server is stopping... :raised_hand:";
            public transient TextNode stoppingNode;
            @Comment(value="The server stopped and is offline\nUsages: ${uptime [format]}")
            public String stopped = "Server stopped! :no_entry:";
            public transient TextNode stoppedNode;
            @Comment(value="The server stopped unexpectedly and is inaccessible\nUsages: ${reason} and ${uptime [format]}")
            public String crashed = "Server crash detected! :warning:\n_${reason}_";
            public transient TextNode crashedNode;
            @Comment(value="True if a crash report should be attached to any server crash messages")
            public boolean uploadCrashReport = false;
        }

        public static class MinecraftSchema {
            @Comment(value="A user sent a message\nUsages: ${author}, ${tag}, ${username}, ${discriminator}, ${message} and ${raw}")
            public String chat = "<<cmd:'@${tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${author}</color></hover></cmd>> ${message}";
            public transient TextNode chatNode;
            @Comment(value="A user sent a message in reply to another\nUsages: ${author}, ${tag}, ${username}, ${discriminator}, ${message}, ${raw}, ${reply_author}, ${reply_tag}, ${reply_username}, ${reply_discriminator}, ${reply_message} and ${reply_raw}")
            public String reply = "<<cmd:'@${tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${author}</color></hover></cmd>> (in reply to <cmd:'@${reply_tag} '><hover:show_text:'${reply_message}'><color:#00aaff>${reply_author}</color></hover></cmd>) ${message}";
            public transient TextNode replyNode;
            @Comment(value="A user edited their recently sent message\nUsages: ${author}, ${tag}, ${username}, ${discriminator}, ${diff}, ${message}, ${raw}, ${original} and ${original_raw}")
            public String edit = "<<cmd:'@${tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${author}</color></hover></cmd>> ${diff}";
            public transient TextNode editNode;
            @Comment(value="A user reacted to a recent message\nUsages: ${issuer}, ${issuer_tag}, ${issuer_username}, ${issuer_discriminator}, ${author}, ${author_tag}, ${author_username}, ${author_discriminator} and ${emote}")
            public String react = "<cmd:'@${issuer_tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${issuer}</color></hover></cmd> reacted with <green>${emote}</green> to <cmd:'@${author_tag} '><color:#00aaff>${author}</color></cmd>'s message";
            public transient TextNode reactNode;
            @Comment(value="A user removed their reaction from a recent message\nUsages: ${issuer}, ${issuer_tag}, ${issuer_username}, ${issuer_discriminator}, ${author}, ${author_tag}, ${author_username}, ${author_discriminator} and ${emote}")
            public String unreact = "<cmd:'@${issuer_tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${issuer}</color></hover></cmd> removed their reaction of <red>${emote}</red> from <cmd:'@${author_tag} '><color:#00aaff>${author}</color></cmd>'s message";
            public transient TextNode unreactNode;
            @Comment(value="A user sent a message that contained stickers\nUsages: ${author}, ${tag}, ${username}, ${discriminator}, ${url} and ${name}")
            public String sticker = "<<cmd:'@${tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${author}</color></hover></cmd>> <url:'${url}'><hover:show_text:'Sticker'><underline><blue>${name}</blue></underline></hover></url>";
            public transient TextNode stickerNode;
            @Comment(value="A user sent a message that contained attachments\nUsages: ${author}, ${tag}, ${username}, ${discriminator}, ${url}, ${name}, ${ext} and ${size}")
            public String attachment = "<<cmd:'@${tag} '><hover:show_text:'<i>Sent from Discord</i>'><color:#00aaff>${author}</color></hover></cmd>> <url:'${url}'><hover:show_text:'${ext} (${size})'><underline><blue>${name}</blue></underline></hover></url>";
            public transient TextNode attachmentNode;
        }
    }
}

