/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.chat.util;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.impl.chat.MinecordChat;
import me.axieum.mcmod.minecord.impl.chat.config.ChatConfig;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import org.jetbrains.annotations.Nullable;

public final class DiscordDispatcher {
    private DiscordDispatcher() {
    }

    public static void embed(BiConsumer<EmbedBuilder, ChatConfig.ChatEntrySchema> builder, Predicate<ChatConfig.ChatEntrySchema> predicate) {
        DiscordDispatcher.embed(builder, (action, entry) -> action.queue(), predicate);
    }

    public static void embedWithAvatar(BiConsumer<EmbedBuilder, ChatConfig.ChatEntrySchema> builder, Predicate<ChatConfig.ChatEntrySchema> predicate, @Nullable String uuid) {
        DiscordDispatcher.embedWithAvatar(builder, (action, entry) -> action.queue(), predicate, uuid);
    }

    public static void embed(BiConsumer<EmbedBuilder, ChatConfig.ChatEntrySchema> builder, BiConsumer<MessageCreateAction, ChatConfig.ChatEntrySchema> action, Predicate<ChatConfig.ChatEntrySchema> predicate) {
        DiscordDispatcher.dispatch((message, entry) -> builder.andThen((m, e) -> message.setEmbeds(new MessageEmbed[]{m.build()})).accept(new EmbedBuilder(), (ChatConfig.ChatEntrySchema)entry), action, predicate);
    }

    public static void embedWithAvatar(BiConsumer<EmbedBuilder, ChatConfig.ChatEntrySchema> builder, BiConsumer<MessageCreateAction, ChatConfig.ChatEntrySchema> action, Predicate<ChatConfig.ChatEntrySchema> predicate, @Nullable String uuid) {
        DiscordDispatcher.embed((message, entry) -> {
            Minecord.getInstance().getAvatarUrl(uuid, 16).ifPresent(arg_0 -> ((EmbedBuilder)message).setThumbnail(arg_0));
            builder.accept((EmbedBuilder)message, (ChatConfig.ChatEntrySchema)entry);
        }, action, predicate);
    }

    public static void dispatch(BiConsumer<MessageCreateBuilder, ChatConfig.ChatEntrySchema> builder, Predicate<ChatConfig.ChatEntrySchema> predicate) {
        DiscordDispatcher.dispatch(builder, (action, entry) -> action.queue(), predicate);
    }

    public static void dispatch(BiConsumer<MessageCreateBuilder, ChatConfig.ChatEntrySchema> builder, BiConsumer<MessageCreateAction, ChatConfig.ChatEntrySchema> action, Predicate<ChatConfig.ChatEntrySchema> predicate) {
        Minecord.getInstance().getJDA().ifPresent(jda -> ((Stream)Arrays.stream(MinecordChat.getConfig().entries).parallel()).filter(predicate).forEach(entry -> {
            @Nullable GuildMessageChannel channel = (GuildMessageChannel)jda.getChannelById(GuildMessageChannel.class, entry.id);
            if (channel == null) {
                MinecordChat.LOGGER.warn("Could not find Discord channel with identifier {}", (Object)entry.id);
            } else if (!channel.canTalk()) {
                MinecordChat.LOGGER.warn("Missing permissions for Discord channel with identifier {}", (Object)entry.id);
            } else {
                builder.andThen((m, e) -> action.accept(channel.sendMessage(m.build()), (ChatConfig.ChatEntrySchema)e)).accept(new MessageCreateBuilder(), (ChatConfig.ChatEntrySchema)entry);
            }
        }));
    }
}

