/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.api.cmds.command;

import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import org.jetbrains.annotations.NotNull;

public enum CooldownScope {
    USER("U:%1$d"),
    CHANNEL("C:%2$d"),
    USER_CHANNEL("U:%1$d|C:%2$d"),
    GUILD("G:%3$d"),
    USER_GUILD("U:%1$d|G:%3$d"),
    SHARD("S:%4$d"),
    USER_SHARD("U:%1$d|S:%4$d"),
    GLOBAL("global");

    private final String format;

    private CooldownScope(String format) {
        this.format = format;
    }

    @NotNull
    public String getKey(@NotNull SlashCommandInteractionEvent event) {
        if (!(event.isFromGuild() || this != GUILD && this != USER_GUILD)) {
            return CHANNEL.getKey(event);
        }
        if (event.getJDA().getShardInfo() == null) {
            if (this == SHARD) {
                return GLOBAL.getKey(event);
            }
            if (this == USER_SHARD) {
                return USER.getKey(event);
            }
        }
        return event.getName() + "|" + String.format(this.format, event.getUser() != null ? event.getUser().getIdLong() : -1L, event.getChannel() != null ? event.getChannel().getIdLong() : -1L, event.getGuild() != null ? event.getGuild().getIdLong() : -1L, event.getJDA().getShardInfo() != null ? event.getJDA().getShardInfo().getShardId() : -1);
    }
}

