/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.cmds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.addon.MinecordAddon;
import me.axieum.mcmod.minecord.api.cmds.MinecordCommands;
import me.axieum.mcmod.minecord.api.cmds.command.MinecordCommand;
import me.axieum.mcmod.minecord.api.cmds.event.JDACommandEvents;
import me.axieum.mcmod.minecord.impl.cmds.callback.DiscordCommandListener;
import me.axieum.mcmod.minecord.impl.cmds.command.discord.CustomCommand;
import me.axieum.mcmod.minecord.impl.cmds.command.discord.TPSCommand;
import me.axieum.mcmod.minecord.impl.cmds.command.discord.UptimeCommand;
import me.axieum.mcmod.minecord.impl.cmds.config.CommandConfig;
import me.shedaniel.autoconfig.AutoConfig;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecordCommandsImpl
implements MinecordCommands,
MinecordAddon {
    public static final MinecordCommands INSTANCE = new MinecordCommandsImpl();
    public static final Logger LOGGER = LogManager.getLogger((String)"Minecord|Commands");
    private static final HashMap<String, MinecordCommand> COMMANDS = new HashMap(2);
    private static final HashMap<String, Long> COOLDOWNS = new HashMap();

    public void onInitializeMinecord(JDABuilder builder) {
        LOGGER.info("Minecord Commands is getting ready...");
        CommandConfig.load();
        builder.addEventListeners(new Object[]{new DiscordCommandListener()});
    }

    public static void initCommands(CommandConfig config) {
        MinecordCommands commands = MinecordCommands.getInstance();
        if (config.builtin.uptime.enabled) {
            try {
                LOGGER.info("Adding built-in uptime command as '/{}'", (Object)config.builtin.uptime.name);
                commands.addCommand(config.builtin.uptime.name, new UptimeCommand(config.builtin.uptime));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Encountered invalid built-in uptime command!", (Throwable)e);
            }
        } else {
            LOGGER.info("Skipping disabled built-in uptime command");
        }
        if (config.builtin.tps.enabled) {
            try {
                LOGGER.info("Adding built-in ticks-per-second (TPS) command as '/{}'", (Object)config.builtin.uptime.name);
                commands.addCommand(config.builtin.tps.name, new TPSCommand(config.builtin.tps));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Encountered invalid built-in ticks-per-second (TPS) command!", (Throwable)e);
            }
        } else {
            LOGGER.info("Skipping disabled built-in ticks-per-second (TPS) command");
        }
        for (CommandConfig.CustomCommandSchema c : config.custom) {
            if (c.enabled) {
                try {
                    LOGGER.info("Adding custom command as '/{}' to run '{}'", (Object)c.name, (Object)c.command);
                    commands.addCommand(c.name, new CustomCommand(c));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Encountered invalid custom '/{}' command!", (Object)c.name, (Object)e);
                }
                continue;
            }
            LOGGER.info("Skipping disabled custom command '/{}'", (Object)c.name);
        }
        commands.clearCooldowns();
    }

    @Override
    public void updateCommandList() {
        Minecord.getInstance().getJDA().ifPresentOrElse(jda -> {
            LOGGER.info("Updating the Discord command list...");
            CommandListUpdateAction commands = jda.updateCommands();
            COMMANDS.values().stream().map(MinecordCommand::getSlashCommandData).forEach(xva$0 -> commands.addCommands(new CommandData[]{xva$0}));
            commands = ((JDACommandEvents.BeforeUpdateCommandList)JDACommandEvents.BEFORE_UPDATE_COMMAND_LIST.invoker()).onUpdatingCommandList(commands);
            commands.queue(cmds -> {
                LOGGER.info("Updated {} commands in Discord - they can take up to an hour to appear!", (Object)cmds.size());
                ((JDACommandEvents.AfterUpdateCommandList)JDACommandEvents.AFTER_UPDATE_COMMAND_LIST.invoker()).onUpdateCommandList((List<Command>)cmds);
            }, error -> LOGGER.error("Could not update the command list in Discord!", error));
        }, () -> LOGGER.warn("Unable to update the command list in Discord as the bot is not yet connected!"));
    }

    @Override
    @Nullable
    public MinecordCommand addCommand(@NotNull String name, @NotNull MinecordCommand command) {
        @Nullable MinecordCommand oldCommand = COMMANDS.put(name, command);
        Minecord.getInstance().getJDA().ifPresent(jda -> {
            if (oldCommand != null) {
                jda.removeEventListener(new Object[]{oldCommand});
            }
            jda.addEventListener(new Object[]{command});
        });
        return oldCommand;
    }

    @Override
    @Nullable
    public MinecordCommand removeCommand(@NotNull String name) {
        @Nullable MinecordCommand command = COMMANDS.remove(name);
        if (command != null) {
            Minecord.getInstance().getJDA().ifPresent(jda -> jda.removeEventListener(new Object[]{command}));
        }
        return command;
    }

    @Override
    public boolean hasCommand(@Nullable String name) {
        return COMMANDS.containsKey(name);
    }

    @Override
    public Optional<MinecordCommand> getCommand(@Nullable String name) {
        return Optional.ofNullable(COMMANDS.get(name));
    }

    @Override
    public List<MinecordCommand> getCommands() {
        return List.copyOf(COMMANDS.values());
    }

    @Override
    public void applyCooldown(@NotNull String key, int seconds) {
        if (seconds > 0) {
            COOLDOWNS.put(key, System.currentTimeMillis() + (long)seconds * 1000L);
        }
    }

    @Override
    public int getCooldown(@NotNull String key) {
        int remaining = 0;
        if (COOLDOWNS.containsKey(key) && (remaining = Math.max(0, (int)Math.round((double)(COOLDOWNS.get(key) - System.currentTimeMillis()) / 1000.0))) == 0) {
            this.clearCooldown(key);
        }
        return remaining;
    }

    @Override
    public Map<String, Long> getCooldowns() {
        return Map.copyOf(COOLDOWNS);
    }

    @Override
    @Nullable
    public Long clearCooldown(@NotNull String key) {
        return COOLDOWNS.remove(key);
    }

    @Override
    public void clearCooldowns() {
        COOLDOWNS.clear();
    }

    @Override
    public void clearInactiveCooldowns() {
        long now = System.currentTimeMillis();
        COOLDOWNS.values().removeIf(endsAt -> now >= endsAt);
    }

    public static CommandConfig getConfig() {
        return (CommandConfig)AutoConfig.getConfigHolder(CommandConfig.class).getConfig();
    }
}

