/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.cmds.callback;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.cmds.MinecordCommands;
import me.axieum.mcmod.minecord.api.cmds.command.MinecordCommand;
import me.axieum.mcmod.minecord.api.cmds.event.MinecordCommandEvents;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.cmds.MinecordCommandsImpl;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DiscordCommandListener
extends ListenerAdapter {
    public void onReady(ReadyEvent event) {
        MinecordCommands.getInstance().getCommands().forEach(arg_0 -> DiscordCommandListener.lambda$onReady$0(event.getJDA(), arg_0));
        MinecordCommands.getInstance().updateCommandList();
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        MinecordCommands minecordCommands = MinecordCommands.getInstance();
        String username = event.getUser().getName();
        String raw = event.getCommandString();
        minecordCommands.getCommand(event.getName()).ifPresentOrElse(command -> {
            boolean isEphemeral = command.isEphemeral();
            event.deferReply(isEphemeral).queue();
            event.getHook().setEphemeral(isEphemeral);
            @Nullable MinecraftServer server = Minecord.getInstance().getMinecraft().orElse(null);
            PlaceholderContext pCtx = server != null ? PlaceholderContext.of((MinecraftServer)server) : null;
            try {
                if (command.requiresMinecraft() && (server == null || server.method_54832() == 0.0f)) {
                    MinecordCommandsImpl.LOGGER.warn("@{} used '{}' but the server is not yet ready!", (Object)username, (Object)raw);
                    event.getHook().sendMessageEmbeds(new EmbedBuilder().setColor(0xFF8800).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)MinecordCommandsImpl.getConfig().messages.unavailableNode, (PlaceholderContext)pCtx, Collections.emptyMap())).build(), new MessageEmbed[0]).queue();
                    return;
                }
                if (command.getCooldown() > 0) {
                    String cooldownKey = command.getCooldownScope().getKey(event);
                    int remaining = minecordCommands.getCooldown(cooldownKey);
                    if (remaining > 0) {
                        MinecordCommandsImpl.LOGGER.warn("@{} used '{}' but must wait another {} seconds!", (Object)username, (Object)raw, (Object)remaining);
                        event.getHook().setEphemeral(true).sendMessageEmbeds(new EmbedBuilder().setColor(0xFF8800).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)MinecordCommandsImpl.getConfig().messages.cooldownNode, (PlaceholderContext)pCtx, Map.of("cooldown", PlaceholdersExt.duration((Duration)Duration.ofSeconds(command.getCooldown())), "remaining", PlaceholdersExt.duration((Duration)Duration.ofSeconds(remaining))))).build(), new MessageEmbed[0]).queue();
                        return;
                    }
                    MinecordCommandsImpl.LOGGER.debug("Applying cooldown '{}' for {} seconds", (Object)cooldownKey, (Object)command.getCooldown());
                    minecordCommands.applyCooldown(cooldownKey, command.getCooldown());
                }
                if (!((MinecordCommandEvents.BeforeExecute)MinecordCommandEvents.BEFORE_EXECUTE.invoker()).onBeforeMinecordCommand((MinecordCommand)((Object)command), event, server)) {
                    MinecordCommandsImpl.LOGGER.debug("@{} used '{}' but its execution was externally cancelled!", (Object)username, (Object)raw);
                    return;
                }
                MinecordCommandsImpl.LOGGER.info("@{} used '{}'", (Object)username, (Object)raw);
                command.execute(event, server);
                ((MinecordCommandEvents.AfterExecute)MinecordCommandEvents.AFTER_EXECUTE.invoker()).onMinecordCommand((MinecordCommand)((Object)command), event, server);
            }
            catch (Exception e) {
                MinecordCommandsImpl.LOGGER.error("@{} failed to use '{}'", (Object)username, (Object)raw, (Object)e);
                event.getHook().sendMessageEmbeds(new EmbedBuilder().setColor(0xFF0000).setDescription((CharSequence)PlaceholdersExt.parseString((TextNode)MinecordCommandsImpl.getConfig().messages.failedNode, (PlaceholderContext)pCtx, Map.of("reason", PlaceholdersExt.string((String)e.getMessage())))).build(), new MessageEmbed[0]).queue();
            }
            finally {
                minecordCommands.clearInactiveCooldowns();
            }
        }, () -> MinecordCommandsImpl.LOGGER.warn("@{} used an unknown command '{}'", (Object)username, (Object)raw));
    }

    private static /* synthetic */ void lambda$onReady$0(JDA rec$, Object xva$0) {
        rec$.addEventListener(new Object[]{xva$0});
    }
}

