/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.cmds.command.discord;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.cmds.command.MinecordCommand;
import me.axieum.mcmod.minecord.api.cmds.event.MinecordCommandEvents;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.cmds.MinecordCommandsImpl;
import me.axieum.mcmod.minecord.impl.cmds.config.CommandConfig;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.exceptions.ParsingException;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.minecraft.class_11560;
import net.minecraft.class_1928;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomCommand
extends MinecordCommand {
    private static final int PERMISSION_LEVEL = 4;
    private final CommandConfig.CustomCommandSchema config;

    public CustomCommand(CommandConfig.CustomCommandSchema config) {
        super(config.name, config.description);
        this.config = config;
        this.setEphemeral(config.ephemeral);
        this.setCooldown(config.cooldown);
        this.setCooldownScope(config.cooldownScope);
        this.data.setDefaultPermissions(config.allowByDefault ? DefaultMemberPermissions.ENABLED : DefaultMemberPermissions.DISABLED);
        Arrays.stream(config.options).map(CommandConfig.BaseCommandSchema.OptionSchema::getOptionData).forEach(xva$0 -> this.data.addOptions(new OptionData[]{xva$0}));
    }

    @Override
    public boolean isEphemeral() {
        return this.config.ephemeral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull SlashCommandInteractionEvent event, @Nullable MinecraftServer server) throws Exception {
        String origCommand;
        assert (server != null);
        try {
            origCommand = CustomCommand.prepareCommand(this.config.commandNode, event.getOptions(), server);
        }
        catch (IllegalArgumentException | ParsingException e) {
            throw new Exception("Unable to prepare Minecraft command!", e);
        }
        String mcCommand = ((MinecordCommandEvents.Custom.AllowExecute)MinecordCommandEvents.Custom.ALLOW_EXECUTE.invoker()).onAllowCustomCommand(this, event, server, origCommand);
        if (mcCommand == null || mcCommand.isEmpty()) {
            return;
        }
        String tag = event.getUser().getName();
        String username = event.getMember() != null ? event.getMember().getEffectiveName() : event.getUser().getName();
        DiscordCommandOutput output = new DiscordCommandOutput(event, server, mcCommand);
        class_2168 origSource = new class_2168((class_2165)output, class_243.field_1353, class_241.field_1340, server.method_30002(), 4, tag, (class_2561)class_2561.method_43470((String)username), server, null);
        class_2168 source = ((MinecordCommandEvents.Custom.BeforeExecute)MinecordCommandEvents.Custom.BEFORE_EXECUTE.invoker()).onBeforeCustomCommand(this, event, server, mcCommand, origSource);
        AtomicBoolean success = new AtomicBoolean(false);
        AtomicInteger result = new AtomicInteger(0);
        CommandSyntaxException error = null;
        try {
            MinecordCommandsImpl.LOGGER.info("@{} is running '/{}'", (Object)tag, (Object)mcCommand);
            ParseResults parseResults = server.method_3734().method_9235().parse(mcCommand, (Object)source.method_9231((bl, i) -> {
                success.set(bl);
                result.set(i);
            }));
            CommandContext context = parseResults.getContext().build(mcCommand);
            CustomCommand.findPlayerUuids((CommandContext<class_2168>)context.getLastChild()).findFirst().flatMap(uuid -> Minecord.getInstance().getAvatarUrl(uuid, 16)).ifPresent(url -> {
                output.thumbnailUrl = url;
            });
            server.method_3734().method_9235().execute(parseResults);
        }
        catch (CommandSyntaxException e) {
            try {
                error = e;
            }
            catch (Throwable throwable) {
                MinecordCommandsImpl.LOGGER.info("@{} ran '/{}' with result {} ({})", (Object)tag, (Object)mcCommand, (Object)result.get(), (Object)(success.get() ? "success" : "fail"));
                throw throwable;
            }
            MinecordCommandsImpl.LOGGER.info("@{} ran '/{}' with result {} ({})", (Object)tag, (Object)mcCommand, (Object)result.get(), (Object)(success.get() ? "success" : "fail"));
        }
        MinecordCommandsImpl.LOGGER.info("@{} ran '/{}' with result {} ({})", (Object)tag, (Object)mcCommand, (Object)result.get(), (Object)(success.get() ? "success" : "fail"));
        ((MinecordCommandEvents.Custom.AfterExecute)MinecordCommandEvents.Custom.AFTER_EXECUTE.invoker()).onCustomCommand(this, event, server, mcCommand, success.get(), result.get(), error);
        if (output.prevMessage == null) {
            if (error == null) {
                output.thumbnailUrl = null;
                source.method_9226(() -> PlaceholdersExt.parseText((TextNode)MinecordCommandsImpl.getConfig().messages.feedbackNode, (PlaceholderContext)PlaceholderContext.of((class_2168)source), Collections.emptyMap()), false);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)error.getMessage()));
            }
        }
    }

    private static String prepareCommand(@NotNull TextNode command, List<OptionMapping> options, @Nullable MinecraftServer server) throws ParsingException {
        if (command == EmptyNode.INSTANCE) {
            return "";
        }
        @Nullable PlaceholderContext ctx = server != null ? PlaceholderContext.of((MinecraftServer)server) : null;
        HashMap placeholders = new HashMap(options.size());
        options.forEach(option -> placeholders.put(option.getName(), PlaceholdersExt.string((String)option.getAsString())));
        String result = PlaceholdersExt.parseString((TextNode)command, (PlaceholderContext)ctx, placeholders).trim();
        return !result.isEmpty() && result.charAt(0) == '/' ? result.substring(1) : result;
    }

    private static Stream<String> findPlayerUuids(CommandContext<class_2168> context) {
        return context.getNodes().stream().map(ParsedCommandNode::getNode).filter(node -> node instanceof ArgumentCommandNode).map(node -> (ArgumentCommandNode)node).map(node -> {
            try {
                if (node.getType() instanceof class_2186) {
                    return class_2186.method_9315((CommandContext)context, (String)node.getName()).method_5845();
                }
                if (node.getType() instanceof class_2191) {
                    Collection c = class_2191.method_9330((CommandContext)context, (String)node.getName());
                    return c.size() == 1 ? ((class_11560)c.iterator().next()).comp_4422().toString() : null;
                }
            }
            catch (CommandSyntaxException | IllegalArgumentException throwable) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private final class DiscordCommandOutput
    implements class_2165 {
        private final SlashCommandInteractionEvent event;
        private final MinecraftServer server;
        private final String mcCommand;
        public boolean erroneous = false;
        @Nullable
        public String prevMessage = null;
        @Nullable
        public String thumbnailUrl = null;

        private DiscordCommandOutput(SlashCommandInteractionEvent event, MinecraftServer server, String mcCommand) {
            this.event = event;
            this.server = server;
            this.mcCommand = mcCommand;
        }

        public void method_43496(class_2561 message) {
            String text = this.prevMessage != null ? this.prevMessage + "\n" + message.getString() : message.getString();
            EmbedBuilder embed = new EmbedBuilder().setColor(!this.erroneous ? 65280 : 0xFF0000).setThumbnail(this.thumbnailUrl).setDescription((CharSequence)text);
            embed = ((MinecordCommandEvents.Custom.Feedback)MinecordCommandEvents.Custom.FEEDBACK.invoker()).onCustomCommandFeedback(CustomCommand.this, this.event, this.server, this.mcCommand, message, !this.erroneous, embed);
            if (embed != null) {
                if (this.prevMessage == null) {
                    this.event.getHook().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
                } else {
                    this.event.getHook().editOriginalEmbeds(new MessageEmbed[]{embed.build()}).queue();
                }
                this.prevMessage = text;
            }
        }

        public boolean method_9200() {
            return true;
        }

        public boolean method_9202() {
            this.erroneous = true;
            return true;
        }

        public boolean method_9201() {
            return this.server.method_3767().method_8355(class_1928.field_19394);
        }
    }
}

