/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.cmds.command.discord;

import java.awt.Color;
import java.util.stream.LongStream;
import me.axieum.mcmod.minecord.api.cmds.command.MinecordCommand;
import me.axieum.mcmod.minecord.api.cmds.event.MinecordCommandEvents;
import me.axieum.mcmod.minecord.impl.cmds.config.CommandConfig;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPSCommand
extends MinecordCommand {
    public TPSCommand(CommandConfig.BaseCommandSchema config) {
        super(config.name, config.description);
        this.data.setDefaultPermissions(config.allowByDefault ? DefaultMemberPermissions.ENABLED : DefaultMemberPermissions.DISABLED);
        this.setEphemeral(config.ephemeral);
        this.setCooldown(config.cooldown);
        this.setCooldownScope(config.cooldownScope);
    }

    @Override
    public void execute(@NotNull SlashCommandInteractionEvent event, @Nullable MinecraftServer server) {
        assert (server != null);
        double meanTPSTime = LongStream.of(server.method_54835()).average().orElse(0.0) * 1.0E-6;
        double meanTPS = Math.min(1000.0 / meanTPSTime, 20.0);
        EmbedBuilder embed = new EmbedBuilder().setDescription((CharSequence)String.format("%.2f TPS @ %.3fms", meanTPS, meanTPSTime)).setColor(Color.HSBtoRGB((float)Math.round(meanTPS / 5.0) / 4.0f / 3.0f, 1.0f, 1.0f));
        embed = ((MinecordCommandEvents.Builtin.TPSCommand)MinecordCommandEvents.Builtin.TPS.invoker()).onTPSCommand(this, event, server, embed);
        event.getHook().sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }
}

