/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.minecord.impl.cmds.config;

import eu.pb4.placeholders.api.node.TextNode;
import java.util.Arrays;
import me.axieum.mcmod.minecord.api.Minecord;
import me.axieum.mcmod.minecord.api.cmds.MinecordCommands;
import me.axieum.mcmod.minecord.api.cmds.command.CooldownScope;
import me.axieum.mcmod.minecord.api.util.PlaceholdersExt;
import me.axieum.mcmod.minecord.impl.cmds.MinecordCommandsImpl;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

@Config(name="minecord/commands")
public class CommandConfig
implements ConfigData {
    @ConfigEntry.Category(value="Messages")
    @Comment(value="Feedback provided to the user who triggered the command")
    public MessagesSchema messages = new MessagesSchema();
    @ConfigEntry.Category(value="Built-in Commands")
    @Comment(value="Built-in Discord commands")
    public BuiltinCommandsSchema builtin = new BuiltinCommandsSchema();
    @ConfigEntry.Category(value="Custom Commands")
    @Comment(value="Custom Discord commands")
    public CustomCommandSchema[] custom = new CustomCommandSchema[]{new CustomCommandSchema()};

    public void validatePostLoad() {
        this.messages.unavailableNode = PlaceholdersExt.parseNode((String)this.messages.unavailable);
        this.messages.failedNode = PlaceholdersExt.parseNode((String)this.messages.failed);
        this.messages.cooldownNode = PlaceholdersExt.parseNode((String)this.messages.cooldown);
        this.messages.feedbackNode = PlaceholdersExt.parseNode((String)this.messages.feedback);
        this.builtin.uptime.messageNode = PlaceholdersExt.parseNode((String)this.builtin.uptime.message);
        Arrays.stream(this.custom).forEach(cmd -> {
            cmd.commandNode = PlaceholdersExt.parseNode((String)cmd.command);
            Arrays.stream(cmd.options).flatMap(option -> Arrays.stream(option.choices)).filter(choice -> choice.value instanceof JsonPrimitive).forEach(choice -> {
                choice.value = ((JsonPrimitive)choice.value).getValue();
            });
        });
        MinecordCommandsImpl.initCommands(this);
        Minecord.getInstance().getJDA().ifPresent(jda -> MinecordCommands.getInstance().updateCommandList());
    }

    public static void load() {
        AutoConfig.register(CommandConfig.class, JanksonConfigSerializer::new);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(CommandConfig.class).load());
    }

    public static class MessagesSchema {
        @Comment(value="The error message used when the Minecraft server is unavailable")
        public String unavailable = "The server is not yet ready - please wait :warning:";
        public transient TextNode unavailableNode;
        @Comment(value="The error message used when any command unexpectedly fails\nUsages: ${reason}")
        public String failed = "**Oh no** - something went wrong! :warning:\n_${reason}_";
        public transient TextNode failedNode;
        @Comment(value="The error message used when a user must wait before executing a command\nUsages: ${cooldown} and ${remaining}")
        public String cooldown = "Please wait another ${remaining} before doing that! :alarm_clock:";
        public transient TextNode cooldownNode;
        @Comment(value="The default message used when a command does not provide any feedback of its own, e.g. '/say'")
        public String feedback = "Consider it done! :thumbsup:";
        public transient TextNode feedbackNode;
    }

    public static class BuiltinCommandsSchema {
        @ConfigEntry.Category(value="Uptime Command")
        @Comment(value="Displays for how long the Minecraft server has been online")
        public UptimeCommandSchema uptime = new UptimeCommandSchema();
        @ConfigEntry.Category(value="TPS Command")
        @Comment(value="Displays the Minecraft server's current ticks-per-second")
        public TPSCommandSchema tps = new TPSCommandSchema();

        public static class UptimeCommandSchema
        extends BaseCommandSchema {
            @Comment(value="A message template that is formatted and sent for the server's uptime\nUsages: ${uptime [format]}")
            public String message = "The server has been online for ${uptime} :hourglass_flowing_sand:";
            public transient TextNode messageNode;

            public UptimeCommandSchema() {
                this.name = "uptime";
                this.description = "Shows for how long the server has been online";
            }
        }

        public static class TPSCommandSchema
        extends BaseCommandSchema {
            public TPSCommandSchema() {
                this.name = "tps";
                this.description = "Shows the server's current ticks-per-second";
            }
        }
    }

    public static class CustomCommandSchema
    extends BaseCommandSchema {
        @Comment(value="A Minecraft command to execute\nUsages: ${<name>} for \"<name>\" option value")
        public String command = "/whitelist ${args:-}";
        public transient TextNode commandNode;
        @ConfigEntry.Category(value="Options")
        @Comment(value="A list of command options")
        public BaseCommandSchema.OptionSchema[] options = new BaseCommandSchema.OptionSchema[]{new BaseCommandSchema.OptionSchema()};

        public CustomCommandSchema() {
            this.name = "whitelist";
            this.description = "Manages the whitelist for the server";
            this.allowByDefault = false;
            this.enabled = false;
        }
    }

    public static abstract class BaseCommandSchema {
        @Comment(value="True if the command should be available for use")
        public boolean enabled = true;
        @Comment(value="Trigger name for the command")
        public String name;
        @Comment(value="A brief description of what the command does")
        public String description;
        @Comment(value="True if the command feedback is only visible to the executor")
        public boolean ephemeral = false;
        @Comment(value="True if anyone can use the command by default")
        public boolean allowByDefault = true;
        @Comment(value="The number of seconds a user must wait before using the command again")
        public int cooldown = 0;
        @Comment(value="To whom the cooldown applies\nAllowed values: USER, CHANNEL, USER_CHANNEL, GUILD, USER_GUILD, SHARD, USER_SHARD and GLOBAL")
        public CooldownScope cooldownScope = CooldownScope.USER;

        public static class OptionSchema {
            @Comment(value="The type of option\nAllowed values: ATTACHMENT, BOOLEAN, CHANNEL, INTEGER, MENTIONABLE, NUMBER, ROLE, STRING and USER")
            public OptionType type = OptionType.STRING;
            @Comment(value="The option name")
            public String name = "args";
            @Comment(value="A brief description of what the option does")
            public String description = "Any additional command arguments";
            @Comment(value="True if the option is required")
            public boolean required = false;
            @ConfigEntry.Category(value="Choices")
            @Comment(value="If non-empty, restricts the value to one of the allowed choices")
            public ChoiceSchema[] choices = new ChoiceSchema[0];

            public OptionData getOptionData() throws IllegalArgumentException {
                OptionData option = new OptionData(this.type, this.name, this.description, this.required);
                for (ChoiceSchema choice : this.choices) {
                    if (choice.value instanceof String) {
                        option.addChoice(choice.name, (String)choice.value);
                        continue;
                    }
                    if (choice.value instanceof Integer) {
                        option.addChoice(choice.name, (long)((Integer)choice.value).intValue());
                        continue;
                    }
                    if (choice.value instanceof Double) {
                        option.addChoice(choice.name, ((Double)choice.value).doubleValue());
                        continue;
                    }
                    if (choice.value instanceof Long) {
                        option.addChoice(choice.name, ((Long)choice.value).longValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Could not derive type for command choice: " + choice.name);
                }
                return option;
            }

            public static class ChoiceSchema {
                @Comment(value="The choice name")
                public String name;
                @Comment(value="The allowed value, which type matches that of the option")
                public Object value;
            }
        }
    }
}

