/*
 * Decompiled with CFR 0.152.
 */
package me.henritom.cubium.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import me.henritom.cubium.CubiumClient;
import me.henritom.cubium.features.uas.UserAgent;
import me.henritom.cubium.features.uas.UserAgentManager;
import me.henritom.cubium.overlay.BrowserOverlay;
import me.henritom.cubium.search.SearchEngine;
import me.henritom.cubium.search.SearchEngineManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0003J\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0003J\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0003J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0003J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0003R\u001e\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001a\u001a\n \u0016*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lme/henritom/cubium/config/ConfigManager;", "", "<init>", "()V", "", "deleteSearchEngines", "checkForSearchEngines", "loadSearchEngines", "Lme/henritom/cubium/search/SearchEngine;", "engine", "", "addSearchEngine", "(Lme/henritom/cubium/search/SearchEngine;)Z", "removeSearchEngine", "loadUserAgents", "saveConfig", "loadConfig", "saveHistory", "loadHistory", "saveBookmarks", "loadBookmarks", "Lnet/minecraft/class_310;", "kotlin.jvm.PlatformType", "client", "Lnet/minecraft/class_310;", "Ljava/io/File;", "configPath", "Ljava/io/File;", "cubium_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nme/henritom/cubium/config/ConfigManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n147#2:242\n147#2:243\n147#2:245\n147#2:247\n147#2:254\n147#2:255\n113#3:244\n113#3:246\n1279#4,2:248\n1293#4,4:250\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nme/henritom/cubium/config/ConfigManager\n*L\n66#1:242\n78#1:243\n87#1:245\n101#1:247\n200#1:254\n234#1:255\n80#1:244\n89#1:246\n130#1:248,2\n130#1:250,4\n*E\n"})
public final class ConfigManager {
    private class_310 client = class_310.method_1551();
    private final File configPath = FabricLoader.getInstance().getConfigDir().resolve("cubium").toFile();

    public final void deleteSearchEngines() {
        File searchEnginesFile;
        if (this.client == null) {
            this.client = class_310.method_1551();
        }
        if ((searchEnginesFile = new File(this.configPath, "search_engines.json")).exists()) {
            searchEnginesFile.delete();
        }
    }

    public final void checkForSearchEngines() {
        File searchEnginesFile;
        if (this.client == null) {
            this.client = class_310.method_1551();
        }
        if (!(searchEnginesFile = new File(this.configPath, "search_engines.json")).exists()) {
            class_3300 resourceManager = this.client.method_1478();
            class_2960 identifier = class_2960.method_60655((String)"cubium", (String)"config/search_engines.json");
            try {
                Object t = resourceManager.method_14486(identifier).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                class_3298 resource = (class_3298)t;
                InputStream inputStream = resource.method_14482();
                Files.createDirectories(searchEnginesFile.getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(inputStream, searchEnginesFile.toPath(), new CopyOption[0]);
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void loadSearchEngines() {
        if (this.client == null) {
            this.client = class_310.method_1551();
        }
        try {
            File file = this.configPath;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
            File file2 = FilesKt.resolve((File)file, (String)"search_engines.json");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String jsonInput = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), charset2));
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List searchEngines = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SearchEngine.Companion.serializer()), jsonInput);
            for (SearchEngine searchEngine : searchEngines) {
                CubiumClient.INSTANCE.getSearchEngineManager().getSearchEngines().add(searchEngine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final boolean addSearchEngine(@NotNull SearchEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Json json = JsonKt.Json$default(null, ConfigManager::addSearchEngine$lambda$0, (int)1, null);
        String jsonInput = FilesKt.readText$default((File)new File(this.configPath, "search_engines.json"), null, (int)1, null);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List searchEngines = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SearchEngine.Companion.serializer()), jsonInput);
        searchEngines.add(engine);
        File file = new File(this.configPath, "search_engines.json");
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        FilesKt.writeText$default((File)file, (String)$this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(SearchEngine.Companion.serializer()), (Object)searchEngines), null, (int)2, null);
        return true;
    }

    public final boolean removeSearchEngine(@NotNull SearchEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Json json = JsonKt.Json$default(null, ConfigManager::removeSearchEngine$lambda$1, (int)1, null);
        String jsonInput = FilesKt.readText$default((File)new File(this.configPath, "search_engines.json"), null, (int)1, null);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List searchEngines = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SearchEngine.Companion.serializer()), jsonInput);
        searchEngines.remove(engine);
        File file = new File(this.configPath, "search_engines.json");
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        FilesKt.writeText$default((File)file, (String)$this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(SearchEngine.Companion.serializer()), (Object)searchEngines), null, (int)2, null);
        return true;
    }

    public final void loadUserAgents() {
        if (this.client == null) {
            this.client = class_310.method_1551();
        }
        class_2960 identifier = class_2960.method_60655((String)"cubium", (String)"config/user_agents.json");
        try {
            InputStream inputStream = ((class_3298)this.client.method_1478().method_14486(identifier).get()).method_14482();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String jsonInput = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset2));
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List userAgents = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(UserAgent.Companion.serializer()), jsonInput);
            for (UserAgent userAgent : userAgents) {
                CubiumClient.INSTANCE.getUserAgentManager().getUserAgents().add(userAgent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig() {
        Map map;
        void $this$associateWith$iv;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File configFile = FilesKt.resolve((File)file, (String)"config.json");
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        Object[] objectArray = new Map[2];
        Object object = new Pair[5];
        SearchEngine searchEngine = CubiumClient.INSTANCE.getSearchEngineManager().getDefaultSearchEngine();
        object[0] = TuplesKt.to((Object)"default_se", (Object)(searchEngine != null ? searchEngine.getTitle() : null));
        object[1] = TuplesKt.to((Object)"user_agent", (Object)CubiumClient.INSTANCE.getUserAgentManager().getUserAgent());
        object[2] = TuplesKt.to((Object)"zoom", (Object)CubiumClient.INSTANCE.getZoom());
        object[3] = TuplesKt.to((Object)"overlay_size_x", (Object)BrowserOverlay.Companion.getOverlaySizeX());
        object[4] = TuplesKt.to((Object)"overlay_size_y", (Object)BrowserOverlay.Companion.getOverlaySizeY());
        objectArray[0] = MapsKt.mapOf((Pair[])object);
        object = CubiumClient.INSTANCE.getFeatureManager().getFeatures().keySet();
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Boolean bl2 = CubiumClient.INSTANCE.getFeatureManager().getFeatures().get(it);
            Intrinsics.checkNotNull((Object)bl2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            Boolean bl3 = (boolean)bl2;
            map.put(t, bl3);
        }
        objectArray2[n] = map = (Map)result$iv;
        List data = CollectionsKt.listOf((Object[])objectArray);
        String string = gson.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)configFile, (String)string, null, (int)2, null);
    }

    public final void loadConfig() {
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File configFile = FilesKt.resolve((File)file, (String)"config.json");
        if (!configFile.exists() || configFile.isDirectory()) {
            return;
        }
        Gson gson = new Gson();
        JsonElement jsonElement = (JsonElement)gson.fromJson(FilesKt.readText$default((File)configFile, null, (int)1, null), JsonElement.class);
        if (jsonElement.isJsonObject()) {
            JsonObject oldConfig = jsonElement.getAsJsonObject();
            Pair[] pairArray = new Pair[4];
            JsonElement jsonElement2 = oldConfig.get("default_se");
            pairArray[0] = TuplesKt.to((Object)"default_se", (Object)(jsonElement2 != null ? jsonElement2.getAsString() : null));
            JsonElement jsonElement3 = oldConfig.get("user_agent");
            pairArray[1] = TuplesKt.to((Object)"user_agent", (Object)(jsonElement3 != null ? jsonElement3.getAsString() : null));
            JsonElement jsonElement4 = oldConfig.get("warden");
            pairArray[2] = TuplesKt.to((Object)"warden", (Object)(jsonElement4 != null ? Boolean.valueOf(jsonElement4.getAsBoolean()) : null));
            JsonElement jsonElement5 = oldConfig.get("zoom");
            pairArray[3] = TuplesKt.to((Object)"zoom", (Object)(jsonElement5 != null ? Double.valueOf(jsonElement5.getAsDouble()) : null));
            Map generalConfig = MapsKt.mapOf((Pair[])pairArray);
            SearchEngineManager searchEngineManager = CubiumClient.INSTANCE.getSearchEngineManager();
            SearchEngineManager searchEngineManager2 = CubiumClient.INSTANCE.getSearchEngineManager();
            Object v = generalConfig.get("default_se");
            String string = v instanceof String ? (String)v : null;
            if (string == null) {
                string = "";
            }
            searchEngineManager.setDefaultSearchEngine(searchEngineManager2.getSearchEngineByTitle(string));
            UserAgentManager userAgentManager = CubiumClient.INSTANCE.getUserAgentManager();
            Object v2 = generalConfig.get("user_agent");
            if (v2 == null) {
                v2 = "";
            }
            userAgentManager.updateUserAgent(v2.toString());
            Double d = (Double)generalConfig.get("zoom");
            CubiumClient.INSTANCE.setZoom((int)(d != null ? d : 0.0));
        } else if (jsonElement.isJsonArray()) {
            Object object = gson.fromJson(jsonElement, List.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, *>>");
            List data = (List)object;
            Map generalConfig = (Map)data.get(0);
            Object e = data.get(1);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Boolean>");
            Map featureConfig = (Map)e;
            SearchEngineManager searchEngineManager = CubiumClient.INSTANCE.getSearchEngineManager();
            SearchEngineManager searchEngineManager3 = CubiumClient.INSTANCE.getSearchEngineManager();
            Object v = generalConfig.get("default_se");
            String string = v instanceof String ? (String)v : null;
            if (string == null) {
                string = "";
            }
            searchEngineManager.setDefaultSearchEngine(searchEngineManager3.getSearchEngineByTitle(string));
            UserAgentManager userAgentManager = CubiumClient.INSTANCE.getUserAgentManager();
            Object v3 = generalConfig.get("user_agent");
            if (v3 == null) {
                v3 = "";
            }
            userAgentManager.updateUserAgent(v3.toString());
            Double d = (Double)generalConfig.get("zoom");
            CubiumClient.INSTANCE.setZoom((int)(d != null ? d : 0.0));
            Double d2 = (Double)generalConfig.get("overlay_size_x");
            BrowserOverlay.Companion.setOverlaySizeX(d2 != null ? d2 : 5.9988002399520095);
            Double d3 = (Double)generalConfig.get("overlay_size_y");
            BrowserOverlay.Companion.setOverlaySizeY(d3 != null ? d3 : 5.9988002399520095);
            CubiumClient.INSTANCE.getFeatureManager().getFeatures().putAll(featureConfig);
        }
    }

    public final void saveHistory() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File historyFile = FilesKt.resolve((File)file, (String)"history.json");
        if (!historyFile.getParentFile().exists()) {
            historyFile.getParentFile().mkdirs();
        }
        if (!historyFile.exists()) {
            historyFile.createNewFile();
        }
        Map data = MapsKt.mapOf((Pair)TuplesKt.to((Object)"history", CubiumClient.INSTANCE.getHistoryManager().getHistory()));
        String string = gson.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)historyFile, (String)string, null, (int)2, null);
    }

    public final void loadHistory() {
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File historyFile = FilesKt.resolve((File)file, (String)"history.json");
        if (!historyFile.exists() || historyFile.isDirectory()) {
            return;
        }
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            String jsonInput = FilesKt.readText((File)historyFile, (Charset)charset);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            HistoryListContainer container = (HistoryListContainer)this_$iv.decodeFromString((DeserializationStrategy)HistoryListContainer.Companion.serializer(), jsonInput);
            CubiumClient.INSTANCE.getHistoryManager().setHistory(CollectionsKt.toMutableList((Collection)container.getHistory()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void saveBookmarks() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File bookmarksFile = FilesKt.resolve((File)file, (String)"bookmarks.json");
        if (!bookmarksFile.getParentFile().exists()) {
            bookmarksFile.getParentFile().mkdirs();
        }
        if (!bookmarksFile.exists()) {
            bookmarksFile.createNewFile();
        }
        Map data = MapsKt.mapOf((Pair)TuplesKt.to((Object)"bookmarks", CubiumClient.INSTANCE.getBookmarkManager().getBookmarks()));
        String string = gson.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)bookmarksFile, (String)string, null, (int)2, null);
    }

    public final void loadBookmarks() {
        File file = this.configPath;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configPath");
        File bookmarksFile = FilesKt.resolve((File)file, (String)"bookmarks.json");
        if (!bookmarksFile.exists() || bookmarksFile.isDirectory()) {
            return;
        }
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            String jsonInput = FilesKt.readText((File)bookmarksFile, (Charset)charset);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            BookmarkListContainer container = (BookmarkListContainer)this_$iv.decodeFromString((DeserializationStrategy)BookmarkListContainer.Companion.serializer(), jsonInput);
            CubiumClient.INSTANCE.getBookmarkManager().setBookmarks(CollectionsKt.toMutableList((Collection)container.getBookmarks()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Unit addSearchEngine$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Unit removeSearchEngine$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

