/*
 * Decompiled with CFR 0.152.
 */
package org.renwixx.yawl;

import com.moandjiezana.toml.Toml;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.renwixx.yawl.Yawl;
import org.slf4j.Logger;

public class LocaleManager {
    private final Yawl plugin;
    private final Path localesDirectory;
    private String locale;
    private final Logger logger;
    private Toml messages;
    private static final List<String> SUPPORTED_LOCALES = List.of("en", "ru", "uk", "de", "fr", "es", "ar", "zh-cn", "ja");

    public LocaleManager(Path dataDirectory, Yawl plugin, String locale, Logger logger) {
        this.localesDirectory = dataDirectory.resolve("locales");
        this.plugin = plugin;
        this.locale = locale;
        this.logger = logger;
        this.reload();
    }

    public void reload() {
        SUPPORTED_LOCALES.forEach(this::saveDefaultLocale);
        Path localeFile = this.localesDirectory.resolve(this.locale + ".toml");
        if (!Files.exists(localeFile, new LinkOption[0])) {
            this.logger.warn("Locale file '{}' not found. Falling back to 'en.toml'.", (Object)(this.locale + ".toml"));
            localeFile = this.localesDirectory.resolve("en.toml");
        }
        try {
            this.messages = new Toml().read(localeFile.toFile());
            this.logger.info("Successfully loaded messages from '{}'.", (Object)localeFile.getFileName());
        }
        catch (Exception e) {
            this.logger.error("Failed to load locale file '{}'. Using empty messages.", (Object)localeFile.getFileName(), (Object)e);
            this.messages = new Toml();
        }
    }

    private void saveDefaultLocale(String localeCode) {
        block11: {
            try {
                Path localeFile;
                if (!Files.exists(this.localesDirectory, new LinkOption[0])) {
                    Files.createDirectories(this.localesDirectory, new FileAttribute[0]);
                }
                if (Files.exists(localeFile = this.localesDirectory.resolve(localeCode + ".toml"), new LinkOption[0])) break block11;
                try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("locales/" + localeCode + ".toml");){
                    if (in == null) {
                        this.logger.error("Default locale file for '{}' not found in JAR.", (Object)localeCode);
                        return;
                    }
                    Files.copy(in, localeFile, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                this.logger.error("Could not save default locale file for '{}'.", (Object)localeCode, (Object)e);
            }
        }
    }

    public Component getMessageFor(CommandSource source, String key, TagResolver ... placeholders) {
        Player player;
        if (!this.plugin.shouldUseClientLocale()) {
            return this.getMessage(key, placeholders);
        }
        String lang = null;
        if (source instanceof Player && (player = (Player)source).getPlayerSettings().getLocale() != null) {
            lang = player.getPlayerSettings().getLocale().getLanguage();
        }
        if (lang != null && Files.exists(this.localesDirectory.resolve(lang + ".toml"), new LinkOption[0])) {
            try {
                Toml localMessages = new Toml().read(this.localesDirectory.resolve(lang + ".toml").toFile());
                String msg = localMessages.getString(key, this.messages.getString(key, key));
                return Yawl.MINI_MESSAGE.deserialize(msg, placeholders);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load messages for '{}', using default locale.", (Object)lang, (Object)e);
            }
        }
        return this.getMessage(key, placeholders);
    }

    public String getMessageString(String key) {
        return this.messages.getString(key, "<red>Missing message for key: " + key + "</red>");
    }

    public Component getMessage(String key, TagResolver ... placeholders) {
        String message = this.getMessageString(key);
        return Yawl.MINI_MESSAGE.deserialize(message, placeholders);
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.reload();
    }
}

