/*
 * Decompiled with CFR 0.152.
 */
package org.renwixx.yawl;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public class PluginConfig {
    private final boolean enabled;
    private final String locale;
    private final boolean caseSensitive;
    private final boolean useClientLocale;

    public PluginConfig(Path dataDirectory, Logger logger) {
        Path configFile = this.saveDefaultConfig(dataDirectory, logger);
        Toml toml = configFile != null ? new Toml().read(configFile.toFile()) : new Toml();
        this.enabled = toml.getBoolean("settings.enabled", Boolean.valueOf(true));
        this.locale = toml.getString("settings.locale", "en");
        this.caseSensitive = toml.getBoolean("settings.case-sensitive", Boolean.valueOf(false));
        this.useClientLocale = toml.getBoolean("settings.use-client-locale", Boolean.valueOf(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path saveDefaultConfig(Path dataDirectory, Logger logger) {
        Path configFile = dataDirectory.resolve("config.toml");
        if (Files.exists(configFile, new LinkOption[0])) return configFile;
        try {
            Files.createDirectories(dataDirectory, new FileAttribute[0]);
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("config.toml");){
                if (in == null) {
                    logger.error("Default config.toml not found in the plugin JAR!");
                    Path path = null;
                    return path;
                }
                Files.copy(in, configFile, new CopyOption[0]);
                return configFile;
            }
        }
        catch (IOException e) {
            logger.error("Could not create default config.toml!", (Throwable)e);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isUseClientLocale() {
        return this.useClientLocale;
    }
}

