/*
 * Decompiled with CFR 0.152.
 */
package org.renwixx.yawl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.StringJoiner;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.renwixx.yawl.LocaleManager;
import org.renwixx.yawl.Yawl;
import org.slf4j.Logger;

public final class WhitelistCommand {
    public static BrigadierCommand create(Yawl plugin) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"yawl").executes(context -> {
            ((CommandSource)context.getSource()).sendMessage(plugin.getLocaleManager().getMessage("help-message", new TagResolver[0]));
            return 1;
        });
        LiteralArgumentBuilder addCommand = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            LocaleManager locale = plugin.getLocaleManager();
            if (!source.hasPermission("yawl.command.add")) {
                source.sendMessage(locale.getMessageFor(source, "no-permission", new TagResolver[0]));
                return 1;
            }
            String playerName = ((String)context.getArgument("player", String.class)).trim();
            if (plugin.addPlayer(playerName)) {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "player-added", new TagResolver[]{Placeholder.unparsed((String)"player", (String)playerName)}), plugin);
            } else {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "player-already-exists", new TagResolver[]{Placeholder.unparsed((String)"player", (String)playerName)}), plugin);
            }
            return 1;
        }));
        LiteralArgumentBuilder removeCommand = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> {
            List<String> players = plugin.getWhitelistedPlayers();
            String input = suggestionBuilder.getRemaining();
            players.stream().filter(name -> plugin.getConfig().isCaseSensitive() ? name.startsWith(input) : name.toLowerCase().startsWith(input.toLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)suggestionBuilder).suggest(arg_0));
            return suggestionBuilder.buildFuture();
        }).executes(context -> {
            Player player;
            CommandSource source = (CommandSource)context.getSource();
            LocaleManager locale = plugin.getLocaleManager();
            if (!source.hasPermission("yawl.command.remove")) {
                source.sendMessage(locale.getMessageFor(source, "no-permission", new TagResolver[0]));
                return 1;
            }
            String playerName = ((String)context.getArgument("player", String.class)).trim();
            if (!(source instanceof ConsoleCommandSource) && source instanceof Player && (player = (Player)source).getUsername().equalsIgnoreCase(playerName)) {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "cannot-remove-self", new TagResolver[0]), plugin);
                return 1;
            }
            if (plugin.removePlayer(playerName)) {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "player-removed", new TagResolver[]{Placeholder.unparsed((String)"player", (String)playerName)}), plugin);
            } else {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "player-not-found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)playerName)}), plugin);
            }
            return 1;
        }));
        LiteralArgumentBuilder listCommand = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"list").executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            LocaleManager locale = plugin.getLocaleManager();
            if (!source.hasPermission("yawl.command.list")) {
                source.sendMessage(locale.getMessageFor(source, "no-permission", new TagResolver[0]));
                return 1;
            }
            List<String> players = plugin.getWhitelistedPlayers();
            if (players.isEmpty()) {
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "list-empty", new TagResolver[0]), plugin);
            } else {
                StringJoiner joiner = new StringJoiner(", ");
                players.forEach(joiner::add);
                WhitelistCommand.sendMessageToSource(source, locale.getMessageFor(source, "list-header", new TagResolver[]{Placeholder.unparsed((String)"count", (String)String.valueOf(players.size())), Placeholder.unparsed((String)"players", (String)joiner.toString())}), plugin);
            }
            return 1;
        });
        LiteralArgumentBuilder reloadCommand = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            if (!source.hasPermission("yawl.command.reload")) {
                source.sendMessage(plugin.getLocaleManager().getMessageFor(source, "no-permission", new TagResolver[0]));
                return 1;
            }
            plugin.reload();
            WhitelistCommand.sendMessageToSource(source, plugin.getLocaleManager().getMessageFor(source, "reload-success", new TagResolver[0]), plugin);
            return 1;
        });
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then((ArgumentBuilder)addCommand)).then((ArgumentBuilder)removeCommand)).then((ArgumentBuilder)listCommand)).then((ArgumentBuilder)reloadCommand);
        return new BrigadierCommand(builder);
    }

    private static void sendMessageToSource(CommandSource source, Component message, Yawl plugin) {
        if (source instanceof ConsoleCommandSource) {
            Logger logger = plugin.getLogger();
            String plain = PlainTextComponentSerializer.plainText().serialize(message);
            logger.info(plain);
        } else {
            source.sendMessage(message);
        }
    }
}

