/*
 * Decompiled with CFR 0.152.
 */
package org.renwixx.yawl;

import com.google.inject.Inject;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.renwixx.yawl.ConnectionListener;
import org.renwixx.yawl.LocaleManager;
import org.renwixx.yawl.PluginConfig;
import org.renwixx.yawl.WhitelistCommand;
import org.slf4j.Logger;

@Plugin(id="yetanotherwhitelistplugin", name="yawl", version="1.0", description="Most simple whitelist plugin for Velocity server.", url="https://github.com/renwixx/", authors={"Renwixx"})
public class Yawl {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Map<String, String> whitelistedPlayers = new ConcurrentHashMap<String, String>();
    private boolean useClientLocale = false;
    private PluginConfig config;
    private LocaleManager localeManager;

    @Inject
    public Yawl(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.reload();
        this.server.getEventManager().register((Object)this, (Object)new ConnectionListener(this));
        CommandManager commandManager = this.server.getCommandManager();
        BrigadierCommand yawlCommand = WhitelistCommand.create(this);
        commandManager.register(commandManager.metaBuilder("yawl").build(), (Command)yawlCommand);
        this.logger.info("YAWL (Yet Another Whitelist Plugin) has been enabled!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.saveWhitelistInternal();
    }

    public void reload() {
        this.config = new PluginConfig(this.dataDirectory, this.logger);
        this.useClientLocale = this.config.isUseClientLocale();
        if (this.localeManager == null) {
            this.localeManager = new LocaleManager(this.dataDirectory, this, this.config.getLocale(), this.logger);
        } else {
            this.localeManager.setLocale(this.config.getLocale());
        }
        this.loadWhitelistInternal();
        this.checkAndKickNonWhitelistedPlayers();
    }

    public void checkAndKickNonWhitelistedPlayers() {
        if (!this.config.isEnabled()) {
            return;
        }
        Component kickMessage = this.localeManager.getMessage("kick-message", new TagResolver[0]);
        for (Player player : this.server.getAllPlayers()) {
            if (player.hasPermission("yawl.bypass") || this.isWhitelisted(player.getUsername())) continue;
            player.disconnect(kickMessage);
            this.logger.info("Kicked player {} because they are not in whitelist.", (Object)player.getUsername());
        }
    }

    private String canonical(String name) {
        return this.config.isCaseSensitive() ? name : name.toLowerCase(Locale.ROOT);
    }

    public boolean isWhitelisted(String playerName) {
        return this.whitelistedPlayers.containsKey(this.canonical(playerName));
    }

    public List<String> getWhitelistedPlayers() {
        return List.copyOf(this.whitelistedPlayers.values());
    }

    public boolean addPlayer(String playerName) {
        String processed = playerName.trim();
        if (processed.isEmpty()) {
            return false;
        }
        String canonical = this.canonical(processed);
        if (this.whitelistedPlayers.putIfAbsent(canonical, processed) == null) {
            this.saveWhitelistInternal();
            return true;
        }
        return false;
    }

    public boolean removePlayer(String playerName) {
        String processed = playerName.trim();
        String canonical = this.canonical(processed);
        String removed = this.whitelistedPlayers.remove(canonical);
        if (removed != null) {
            this.saveWhitelistInternal();
            this.server.getPlayer(processed).ifPresent(player -> {
                if (!player.hasPermission("yawl.bypass")) {
                    player.disconnect(this.localeManager.getMessage("kick-message", new TagResolver[0]));
                    this.logger.info("Kicked player {} because they were removed from the whitelist.", (Object)player.getUsername());
                }
            });
            return true;
        }
        return false;
    }

    private Path getWhitelistPath() {
        return this.dataDirectory.resolve("whitelist.txt");
    }

    private void loadWhitelistInternal() {
        Path file = this.getWhitelistPath();
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                Files.write(file, List.of("# Add one player per line", "Player1"), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.error("Could not create whitelist.txt", (Throwable)e);
                return;
            }
        }
        try {
            this.whitelistedPlayers.clear();
            List<String> lines = Files.readAllLines(file);
            lines.stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(name -> this.whitelistedPlayers.put(this.canonical((String)name), (String)name));
            this.logger.info("Loaded {} players from whitelist.txt", (Object)this.whitelistedPlayers.size());
        }
        catch (IOException e) {
            this.logger.error("Could not load whitelist.txt", (Throwable)e);
        }
    }

    private void saveWhitelistInternal() {
        Path file = this.getWhitelistPath();
        Path tempFile = this.dataDirectory.resolve("whitelist.txt.tmp");
        try {
            List<String> sortedPlayers = this.whitelistedPlayers.values().stream().sorted(String.CASE_INSENSITIVE_ORDER).toList();
            Files.write(tempFile, sortedPlayers, new OpenOption[0]);
            Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.logger.error("Could not save whitelist.txt", (Throwable)e);
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public boolean shouldUseClientLocale() {
        return this.useClientLocale;
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

