/*
 * Decompiled with CFR 0.152.
 */
package org.renwixx.yawc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.renwixx.yawc.YawlPlaceholders;

public class YetAnotherWhitelistCompanion
extends JavaPlugin
implements PluginMessageListener,
Listener {
    private final Map<UUID, String> whitelistDurations = new ConcurrentHashMap<UUID, String>();

    public void onEnable() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") == null) {
            this.getLogger().warning("Could not find PlaceholderAPI! This plugin is required.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "yawl:data", (PluginMessageListener)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new YawlPlaceholders(this).register();
        this.getLogger().info("YawlCompanion enabled!");
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        if (!channel.equals("yawl:data")) {
            return;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        try (DataInputStream in = new DataInputStream(stream);){
            UUID playerUUID = UUID.fromString(in.readUTF());
            String duration = in.readUTF();
            this.whitelistDurations.put(playerUUID, duration);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to read plugin message: " + e.getMessage());
        }
    }

    public String getDuration(UUID playerUUID) {
        return this.whitelistDurations.getOrDefault(playerUUID, "N/A");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.whitelistDurations.remove(event.getPlayer().getUniqueId());
    }
}

