/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.SimpleStaticTextDisplaySettings;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.network.packets.cts.AdvancedDisplayUpdatePacket;
import de.mrjulsen.crn.registry.ModBlockEntities;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAdvancedDisplayBlock
extends Block
implements IWrenchable,
IBE<AdvancedDisplayBlockEntity> {
    public static final int DEFAULT_DISPLAY_COLOR = -12566464;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");

    public AbstractAdvancedDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static BlockColor getDisplayColor() {
        return (state, world, pos, layer) -> {
            if (world == null || state == null || pos == null) {
                return -12566464;
            }
            BlockEntity patt0$temp = world.getBlockEntity(pos);
            if (patt0$temp instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)patt0$temp;
                return be.getSettingsAs(BasicDisplaySettings.class).map(x -> {
                    int color = x.getBackColor();
                    return color == 0 ? null : Integer.valueOf(color);
                }).orElse(-12566464);
            }
            return -12566464;
        };
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{UP, DOWN, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos placedOnPos = clickedPos.relative(face.getOpposite());
        Level level = context.getLevel();
        BlockState otherState = level.getBlockState(placedOnPos);
        BlockState stateForPlacement = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        stateForPlacement = otherState.getBlock() != this || context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? this.getDefaultPlacementState(context, stateForPlacement, otherState) : this.appendOnPlace(context, stateForPlacement, otherState);
        return this.updateColumn(level, clickedPos, stateForPlacement, true);
    }

    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        Direction otherFacing = (Direction)other.getValue((Property)FACING);
        state = (BlockState)state.setValue((Property)FACING, (Comparable)otherFacing);
        return state;
    }

    public BlockState getDefaultPlacementState(BlockPlaceContext context, BlockState state, BlockState other) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState updateColumn(Level level, BlockPos pos, BlockState state, boolean present) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction.Axis axis = this.getConnectionAxis(state);
        for (Direction connection : Iterate.directionsInAxis((Direction.Axis)Direction.Axis.Y)) {
            boolean connect = true;
            block1: for (Direction movement : Iterate.directionsInAxis((Direction.Axis)axis)) {
                currentPos.set((Vec3i)pos);
                for (int i = 0; i < 1000 && level.isLoaded((BlockPos)currentPos); ++i) {
                    BlockPos otherPos = currentPos.relative(connection);
                    BlockState other1 = currentPos.equals((Object)pos) ? state : level.getBlockState((BlockPos)currentPos);
                    BlockState other2 = level.getBlockState(otherPos);
                    boolean col1 = this.canConnect((LevelAccessor)level, pos, state, other1);
                    boolean col2 = this.canConnect((LevelAccessor)level, pos, state, other2);
                    currentPos.move(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = AbstractAdvancedDisplayBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.getBlock() == this) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.getBlockTicks();
        if (!blockTicks.hasScheduledTick(pPos, (Object)this)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
        this.updateNeighbours(pState, pLevel, pPos);
        if (pLevel.isClientSide) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.getController().getRenderer().update(pLevel, pPos, pState, (BlockEntity)be, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED));
        }
    }

    public <T extends Comparable<T>> BlockState getPropertyFromNeighbours(BlockState pState, Level pLevel, BlockPos pPos, Property<T> property) {
        Direction leftDirection = ((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise();
        BlockState newState = null;
        BlockPos relPos = pPos.relative(leftDirection);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.relative(Direction.UP);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.relative(leftDirection.getOpposite());
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.relative(Direction.DOWN);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        return pState;
    }

    public <T extends Comparable<T>> BlockState getPropertyFromNeighbour(BlockState pState, Level pLevel, BlockPos pPos, BlockPos relPos, Property<T> property) {
        if (this.canConnectWithBlock((BlockGetter)pLevel, pState, pLevel.getBlockState(relPos))) {
            return (BlockState)pState.setValue(property, pLevel.getBlockState(relPos).getValue(property));
        }
        return null;
    }

    public void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        Direction leftDirection = ((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise();
        BlockPos relPos = pPos.relative(leftDirection);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.relative(Direction.UP);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.relative(leftDirection.getOpposite());
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.relative(Direction.DOWN);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.getBlock() != this) {
            return;
        }
        BlockPos belowPos = pPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.getConnectionAxis(pState), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockState belowState = pLevel.getBlockState(belowPos);
        if (!this.canConnect((LevelAccessor)pLevel, pPos, pState, belowState)) {
            KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)pPos, (BlockState)this.updateColumn((Level)pLevel, pPos, pState, true));
        }
    }

    public BlockState updateShape(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.updatedShapeInner(state, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private BlockState updatedShapeInner(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!this.canConnect(pLevel, pCurrentPos, state, pNeighborState)) {
            return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.getAxis() == this.getConnectionAxis(state)) {
            return this.applyPropertiesOf(state, pNeighborState);
        }
        return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, AbstractAdvancedDisplayBlock.getConnection(pNeighborState, pDirection.getOpposite()));
    }

    public BlockState applyPropertiesOf(BlockState current, BlockState state) {
        BlockState blockState = this.defaultBlockState();
        for (Property property : state.getBlock().getStateDefinition().getProperties()) {
            if (!blockState.hasProperty(property)) continue;
            if (this.getExcludedProperties().contains(property)) {
                blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(current, blockState, property);
                continue;
            }
            blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState copyPropertyOf(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.setValue(property, sourceState.getValue(property));
    }

    protected boolean canConnect(LevelAccessor level, BlockPos pos, BlockState state, BlockState other) {
        return other.getBlock() == this && state.getValue((Property)FACING) == other.getValue((Property)FACING);
    }

    public boolean canConnectWithBlock(BlockGetter level, BlockState selfState, BlockState otherState) {
        return selfState.getBlock() instanceof AbstractAdvancedDisplayBlock && otherState.getBlock() instanceof AbstractAdvancedDisplayBlock && selfState.getBlock() == otherState.getBlock() && selfState.getValue((Property)FACING) == otherState.getValue((Property)FACING);
    }

    protected Direction.Axis getConnectionAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getClockWise().getAxis();
    }

    public static boolean getConnection(BlockState state, Direction side) {
        BooleanProperty property = side == Direction.DOWN ? DOWN : (side == Direction.UP ? UP : null);
        return property != null && (Boolean)state.getValue((Property)property) != false;
    }

    public static BlockState setConnection(BlockState state, Direction side, boolean connect) {
        BooleanProperty property;
        Object object = side == Direction.DOWN ? DOWN : (property = side == Direction.UP ? UP : null);
        if (property != null) {
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pIsMoving || pNewState.getBlock() == this) {
            return;
        }
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.getConnectionAxis(pState))) {
            BlockPos relative = pPos.relative(d);
            BlockState adjacent = pLevel.getBlockState(relative);
            if (!this.canConnect((LevelAccessor)pLevel, pPos, pState, adjacent)) continue;
            KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)relative, (BlockState)this.updateColumn(pLevel, relative, adjacent, false));
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        AdvancedDisplayBlockEntity controller;
        AdvancedDisplayBlockEntity blockEntity = ((AdvancedDisplayBlockEntity)level.getBlockEntity(pos)).getController();
        if (stack.is(Items.GLOW_INK_SAC)) {
            level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.applyToAll(be -> {
                be.setGlowing(true);
                be.notifyUpdate();
            });
            if (level.isClientSide) {
                blockEntity.getRenderer().update(level, pos, state, (BlockEntity)blockEntity, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.NAME_TAG && stack.has(DataComponents.CUSTOM_NAME) && level.isClientSide) {
            AdvancedDisplayBlockEntity controller2 = blockEntity.getController();
            if (controller2 != null) {
                SimpleStaticTextDisplaySettings settings = new SimpleStaticTextDisplaySettings();
                settings.setStaticText(Component.Serializer.toJson((Component)((Component)stack.get(DataComponents.CUSTOM_NAME)), (HolderLookup.Provider)RegistryAccess.EMPTY));
                boolean doubleSided = false;
                if (controller2.getBlockState().getBlock() instanceof AbstractAdvancedSidedDisplayBlock) {
                    doubleSided = controller2.getBlockState().getValue(AbstractAdvancedSidedDisplayBlock.SIDE) == ESide.BOTH;
                }
                DLNetworkManager.sendToServer((BaseNetworkPacket)new AdvancedDisplayUpdatePacket(controller2.getLevel(), controller2.getBlockPos(), ModDisplayTypes.SIMPLE_TEXT, doubleSided, settings));
                return ItemInteractionResult.SUCCESS;
            }
        } else if (AllBlocks.CLIPBOARD.isIn(stack) && level.isClientSide && (controller = blockEntity.getController()) != null) {
            StaticTextDisplaySettings settings = new StaticTextDisplaySettings();
            List entries = ClipboardEntry.getLastViewedEntries((ItemStack)stack);
            int line = 0;
            block0: for (ClipboardEntry entry : entries) {
                for (String string : entry.text.getString().split("\n")) {
                    StaticTextDisplaySettings.TextComponent component = new StaticTextDisplaySettings.TextComponent(string);
                    component.setTextAlignment(EAlignment.LEFT);
                    component.setXScale(0.4f);
                    component.setMinXScale(0.4f);
                    component.setYScale(0.4f);
                    component.setY((float)line * 5.5f);
                    if (line >= settings.getComponentsCount()) {
                        settings.addComponent(component);
                    } else {
                        settings.setComponent(line, component);
                    }
                    if (++line >= controller.getYSize() * 3 - 1) break block0;
                }
            }
            boolean doubleSided = false;
            if (controller.getBlockState().getBlock() instanceof AbstractAdvancedSidedDisplayBlock) {
                doubleSided = controller.getBlockState().getValue(AbstractAdvancedSidedDisplayBlock.SIDE) == ESide.BOTH;
            }
            DLNetworkManager.sendToServer((BaseNetworkPacket)new AdvancedDisplayUpdatePacket(controller.getLevel(), controller.getBlockPos(), ModDisplayTypes.RICH_TEXT, doubleSided, settings));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected boolean updateNeighbour(BlockState pState, Level pLevel, BlockPos pPos, BlockPos neighbourPos) {
        BlockEntity blockEntity;
        if (pLevel.getBlockState(neighbourPos).is((Block)this) && (blockEntity = pLevel.getBlockEntity(neighbourPos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity otherBe = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
                be.copyFrom(otherBe);
                return true;
            }
        }
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        AdvancedDisplayBlockEntity be;
        AdvancedDisplayBlockEntity controller;
        BlockEntity blockEntity;
        Level level = context.getLevel();
        if (level.isClientSide && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof AdvancedDisplayBlockEntity && (controller = (be = (AdvancedDisplayBlockEntity)blockEntity).getController()) != null) {
            ClientWrapper.showAdvancedDisplaySettingsScreen(controller);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public Class<AdvancedDisplayBlockEntity> getBlockEntityClass() {
        return AdvancedDisplayBlockEntity.class;
    }

    public BlockEntityType<? extends AdvancedDisplayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.ADVANCED_DISPLAY_BLOCK_ENTITY.get();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AdvancedDisplayBlockEntity(this.getBlockEntityType(), pos, state);
    }

    public abstract boolean isSingleLined();

    public abstract Tripple<Float, Float, Float> getRenderRotation(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderOffset(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderZOffset(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderAspectRatio(Level var1, BlockState var2, BlockPos var3);

    public Collection<Property<?>> getExcludedProperties() {
        return List.of();
    }
}

