/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowNextConnections;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class PassengerInformationDetailedSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
IShowTrainStatsSetting,
IShowExitDirectionSetting,
ICarriageIndexSetting,
IShowNextConnections,
ITrainTextSetting,
IShowLineColorSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected boolean showStats = true;
    protected boolean showExit = true;
    protected boolean showConnections = true;
    protected byte carriageIndexOffset = 0;
    protected boolean overwriteCarriageIndex = false;
    protected ITrainTextSetting.ETrainTextComponents trainTextComponents = ITrainTextSetting.ETrainTextComponents.TRAIN_NAME;
    protected boolean showLineColor = false;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.getByte("TimeDisplay"));
        }
        if (nbt.contains("ShowStats")) {
            this.showStats = nbt.getBoolean("ShowStats");
        }
        if (nbt.contains("ShowExit")) {
            this.showExit = nbt.getBoolean("ShowExit");
        }
        if (nbt.contains("ShowConnections")) {
            this.showConnections = nbt.getBoolean("ShowConnections");
        }
        if (nbt.contains("CarriageIndexOffset")) {
            this.carriageIndexOffset = nbt.getByte("CarriageIndexOffset");
        }
        if (nbt.contains("OverwriteCarriageIndex")) {
            this.overwriteCarriageIndex = nbt.getBoolean("OverwriteCarriageIndex");
        }
        if (nbt.contains("TrainText")) {
            this.trainTextComponents = ITrainTextSetting.ETrainTextComponents.getById(nbt.getByte("TrainText"));
        }
        if (nbt.contains("ShowLineColor")) {
            this.showLineColor = nbt.getBoolean("ShowLineColor");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putByte("TimeDisplay", this.timeDisplay.getId());
        nbt.putBoolean("ShowStats", this.showStats);
        nbt.putBoolean("ShowExit", this.showExit);
        nbt.putBoolean("ShowConnections", this.showConnections);
        nbt.putByte("CarriageIndexOffset", this.carriageIndexOffset);
        nbt.putBoolean("OverwriteCarriageIndex", this.overwriteCarriageIndex);
        nbt.putByte("TrainText", this.trainTextComponents.getId());
        nbt.putBoolean("ShowLineColor", this.showLineColor);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildShowStatsGui(context);
        this.buildShowExitGui(context);
        this.buildShowConnectionGui(context);
        this.buildShowLineColorGui(context);
        this.buildCarriageIndexGui(context);
        this.buildTrainTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyShowExitSetting(oldSettings);
        this.copyShowStatsSetting(oldSettings);
        this.copyShowConnectionSetting(oldSettings);
        this.copyCarriageIndexSetting(oldSettings);
        this.copyTrainTextSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
    }

    @Override
    public boolean showStats() {
        return this.showStats;
    }

    @Override
    public void setShowStats(boolean b) {
        this.showStats = b;
    }

    @Override
    public boolean showExit() {
        return this.showExit;
    }

    @Override
    public void setShowExit(boolean b) {
        this.showExit = b;
    }

    @Override
    public boolean showConnections() {
        return this.showConnections;
    }

    @Override
    public void setShowConnection(boolean b) {
        this.showConnections = b;
    }

    @Override
    public byte getCarriageIndex() {
        return this.carriageIndexOffset;
    }

    @Override
    public boolean shouldOverwriteCarriageIndex() {
        return this.overwriteCarriageIndex;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }

    @Override
    public void setCarriageIndex(byte b) {
        this.carriageIndexOffset = b;
    }

    @Override
    public void setOverwriteCarriageIndex(boolean b) {
        this.overwriteCarriageIndex = b;
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public ITrainTextSetting.ETrainTextComponents getTrainTextComponents() {
        return this.trainTextComponents;
    }

    @Override
    public void setTrainTextComponents(ITrainTextSetting.ETrainTextComponents v) {
        this.trainTextComponents = v;
    }
}

